/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.vertx;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultEndpointMetric;
import org.apache.servicecomb.foundation.vertx.metrics.metric.DefaultServerEndpointMetric;
import org.apache.servicecomb.metrics.core.meter.vertx.EndpointMeter;

public class ServerEndpointMeter
extends EndpointMeter {
    public static final String REJECT_BY_CONNECTION_LIMIT = "rejectByConnectionLimit";
    private Id idRejectByConnectionLimit;
    private long lastRejectByConnectionLimit;

    public ServerEndpointMeter(Id id, DefaultEndpointMetric metric) {
        super(id, metric);
        this.idRejectByConnectionLimit = this.id.withTag("statistic", REJECT_BY_CONNECTION_LIMIT);
    }

    @Override
    public void calcMeasurements(List<Measurement> measurements, long msNow, double secondInterval) {
        super.calcMeasurements(measurements, msNow, secondInterval);
        long rejectByConnectionLimit = ((DefaultServerEndpointMetric)this.metric).getRejectByConnectionLimitCount();
        measurements.add(this.newMeasurement(this.idRejectByConnectionLimit, msNow, rejectByConnectionLimit - this.lastRejectByConnectionLimit));
        this.lastRejectByConnectionLimit = rejectByConnectionLimit;
    }
}

