/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.extend.introspector;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.introspect.Annotated;
import io.swagger.v3.core.jackson.SwaggerAnnotationIntrospector;
import java.lang.reflect.Type;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.foundation.common.base.EnumUtils;
import org.apache.servicecomb.swagger.extend.SwaggerEnum;

public class JsonPropertyIntrospector
extends SwaggerAnnotationIntrospector {
    private static final long serialVersionUID = 4157263023893695762L;

    public String findEnumValue(Enum<?> value) {
        try {
            JsonProperty annotation = value.getClass().getField(value.name()).getAnnotation(JsonProperty.class);
            if (null == annotation || StringUtils.isEmpty((CharSequence)annotation.value())) {
                return super.findEnumValue(value);
            }
            return annotation.value();
        }
        catch (NoSuchFieldException e) {
            return super.findEnumValue(value);
        }
    }

    public String findPropertyDescription(Annotated annotated) {
        Class enumClass = annotated.getRawType();
        if (enumClass.isEnum()) {
            return SwaggerEnum.JDK.findPropertyDescription(enumClass, annotated.getAnnotated().getAnnotations());
        }
        if (EnumUtils.isDynamicEnum((Type)enumClass)) {
            return SwaggerEnum.DYNAMIC.findPropertyDescription(enumClass, annotated.getAnnotated().getAnnotations());
        }
        return super.findPropertyDescription(annotated);
    }
}

