/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.tracing.zipkin;

import brave.SpanCustomizer;
import brave.Tags;
import brave.http.HttpResponse;
import brave.http.HttpResponseParser;
import brave.http.HttpTags;
import brave.propagation.TraceContext;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.tracing.zipkin.InvocationAware;

public record CustomHttpResponseParser() implements HttpResponseParser
{
    public void parse(HttpResponse response, TraceContext context, SpanCustomizer span) {
        Invocation invocation = ((InvocationAware)response).getInvocation();
        HttpTags.STATUS_CODE.tag((Object)response, context, span);
        if (response.error() != null) {
            span.tag(Tags.ERROR.key(), response.error().getMessage());
        }
        if (!invocation.isProducer()) {
            span.tag(HttpTags.ROUTE.key(), response.route());
        }
    }
}

