/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.priority;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.priority.ConfigObject;
import org.apache.servicecomb.config.priority.ConfigObjectFactory;
import org.apache.servicecomb.config.priority.ConfigObjectProperty;
import org.apache.servicecomb.config.priority.PriorityPropertyFactory;
import org.apache.servicecomb.foundation.common.event.EventManager;

public class PriorityPropertyManager {
    private final ConfigObjectFactory configObjectFactory;
    private final Map<Object, List<ConfigObjectProperty>> configObjectMap = Collections.synchronizedMap(new WeakHashMap());

    public PriorityPropertyManager(ConfigObjectFactory configObjectFactory) {
        this.configObjectFactory = configObjectFactory;
        EventManager.register((Object)this);
    }

    public PriorityPropertyFactory getPropertyFactory() {
        return this.configObjectFactory.getPropertyFactory();
    }

    public void close() {
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (Map.Entry<Object, List<ConfigObjectProperty>> entry : this.configObjectMap.entrySet()) {
            Object instance = entry.getKey();
            entry.getValue().forEach(configObjectProperty -> {
                for (String updatedKey : event.getChanged()) {
                    configObjectProperty.updateValueWhenChanged(instance, updatedKey);
                }
            });
        }
    }

    @VisibleForTesting
    public Map<Object, List<ConfigObjectProperty>> getConfigObjectMap() {
        return this.configObjectMap;
    }

    public <T> T createConfigObject(Class<T> cls, Object ... kvs) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int idx = 0; idx < kvs.length; idx += 2) {
            parameters.put(kvs[idx].toString(), kvs[idx + 1]);
        }
        return (T)this.createConfigObject((T)cls, (Map<String, Object>)parameters);
    }

    public <T> T createConfigObject(Class<T> cls, Map<String, Object> parameters) {
        ConfigObject<Class<T>> configObject = this.configObjectFactory.create(cls, parameters);
        return (T)this.saveConfigObject(configObject);
    }

    public <T> T createConfigObject(T instance, Map<String, Object> parameters) {
        ConfigObject<T> configObject = this.configObjectFactory.create(instance, parameters);
        return this.saveConfigObject(configObject);
    }

    private <T> T saveConfigObject(ConfigObject<T> configObject) {
        this.configObjectMap.put(configObject.getInstance(), configObject.getProperties());
        return configObject.getInstance();
    }
}

