/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.apollo;

import org.springframework.core.env.Environment;

public class ApolloConfig {
    private static final String SERVER_URL_KEY = "apollo.config.serverUri";
    private static final String SERVER_NAMESPACE = "apollo.config.namespace";
    private static final String SERVER_ENV = "apollo.config.env";
    private static final String SERVER_CLUSTERS = "apollo.config.clusters";
    private static final String APOLLO_SERVICE_NAME = "apollo.config.serviceName";
    private static final String TOKEN = "apollo.config.token";
    private static final String REFRESH_INTERVAL = "apollo.config.refreshInterval";
    private static final String FIRST_REFRESH_INTERVAL = "apollo.config.firstRefreshInterval";
    private static final int DEFAULT_REFRESH_INTERVAL = 3;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;
    private final Environment environment;

    public ApolloConfig(Environment environment) {
        this.environment = environment;
    }

    public String getServiceName() {
        return this.environment.getProperty(APOLLO_SERVICE_NAME);
    }

    public String getServerUri() {
        return this.environment.getProperty(SERVER_URL_KEY);
    }

    public String getToken() {
        return this.environment.getProperty(TOKEN);
    }

    public String getEnv() {
        return this.environment.getProperty(SERVER_ENV);
    }

    public String getNamespace() {
        return this.environment.getProperty(SERVER_NAMESPACE);
    }

    public String getServerClusters() {
        return this.environment.getProperty(SERVER_CLUSTERS);
    }

    public int getRefreshInterval() {
        return (Integer)this.environment.getProperty(REFRESH_INTERVAL, Integer.TYPE, (Object)3);
    }

    public int getFirstRefreshInterval() {
        return (Integer)this.environment.getProperty(FIRST_REFRESH_INTERVAL, Integer.TYPE, (Object)0);
    }
}

