/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.felix.http.jakartawrappers.ServletConfigWrapper;
import org.apache.felix.http.javaxwrappers.ServletExceptionUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.servlets.JakartaOptingServlet;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.wrappers.JavaxToJakartaRequestWrapper;
import org.apache.sling.api.wrappers.JavaxToJakartaResponseWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JakartaToJavaxServletWrapper
implements Servlet {
    private final jakarta.servlet.Servlet servlet;

    @Nullable
    public static Servlet toJavaxServlet(@Nullable jakarta.servlet.Servlet servlet) {
        if (servlet != null) {
            if (servlet instanceof JakartaOptingServlet) {
                return new JakartaToJavaxOptingServletWrapper((JakartaOptingServlet)servlet);
            }
            return new JakartaToJavaxServletWrapper(servlet);
        }
        return null;
    }

    public JakartaToJavaxServletWrapper(jakarta.servlet.Servlet servlet) {
        this.servlet = servlet;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.servlet.init((jakarta.servlet.ServletConfig)new ServletConfigWrapper(config));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)e);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        try {
            this.servlet.service(JavaxToJakartaRequestWrapper.toJakartaRequest(req), JavaxToJakartaResponseWrapper.toJakartaResponse(res));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)e);
        }
    }

    public void destroy() {
        this.servlet.destroy();
    }

    public ServletConfig getServletConfig() {
        if (this.servlet.getServletConfig() == null) {
            return null;
        }
        return new org.apache.felix.http.javaxwrappers.ServletConfigWrapper(this.servlet.getServletConfig());
    }

    public String getServletInfo() {
        return this.servlet.getServletInfo();
    }

    public static class JakartaToJavaxOptingServletWrapper
    extends JakartaToJavaxServletWrapper
    implements OptingServlet {
        private final JakartaOptingServlet servlet;

        public JakartaToJavaxOptingServletWrapper(JakartaOptingServlet servlet) {
            super(servlet);
            this.servlet = servlet;
        }

        @Override
        public boolean accepts(@NotNull SlingHttpServletRequest request) {
            return this.servlet.accepts(JavaxToJakartaRequestWrapper.toJakartaRequest(request));
        }
    }
}

