/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2.sp;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.sling.auth.saml2.SAML2RuntimeException;

public abstract class JksCredentials {
    protected static KeyStore getKeyStore(String filePathToJKS, char[] jksPassword) {
        KeyStore keyStore;
        FileInputStream fis = new FileInputStream(filePathToJKS);
        try {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(fis, jksPassword);
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new SAML2RuntimeException(e);
            }
        }
        ((InputStream)fis).close();
        return keyStore;
    }

    protected JksCredentials() {
        throw new IllegalStateException("Utility class");
    }
}

