/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.agent.impl.DistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.agent.impl.PrivilegeDistributionRequestAuthorizationStrategy;
import org.apache.sling.distribution.common.DistributionException;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={DistributionRequestAuthorizationStrategy.class}, immediate=true, property={"webconsole.configurationFactory.nameHint=Strategy name: {name}"})
@Designate(ocd=Config.class, factory=true)
public class PrivilegeDistributionRequestAuthorizationStrategyFactory
implements DistributionRequestAuthorizationStrategy {
    private DistributionRequestAuthorizationStrategy authorizationStrategy;

    @Activate
    public void activate(BundleContext context, Config conf) {
        String jcrPrivilege = conf.jcrPrivilege();
        String[] jcrAddPrivileges = conf.additionalJcrPrivilegesForAdd();
        String[] jcrDeletePrivileges = conf.additionalJcrPrivilegesForDelete();
        this.authorizationStrategy = new PrivilegeDistributionRequestAuthorizationStrategy(jcrPrivilege, jcrAddPrivileges, jcrDeletePrivileges);
    }

    @Override
    public void checkPermission(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest distributionRequest) throws DistributionException {
        this.authorizationStrategy.checkPermission(resourceResolver, distributionRequest);
    }

    @ObjectClassDefinition(name="Apache Sling Distribution Request Authorization - Privilege Request Authorization Strategy", description="OSGi configuration for request based authorization strategy based on privileges")
    public static @interface Config {
        @AttributeDefinition(name="name")
        public String name() default "";

        @AttributeDefinition(name="Jcr Privilege", description="Jcr privilege to check for authorizing distribution requests. The privilege is checked for the calling user session.")
        public String jcrPrivilege() default "";

        @AttributeDefinition(cardinality=100, name="Additional Jcr Privileges for Add", description="Additional Jcr privileges to check for authorizing ADD distribution requests. The privilege is checked for the calling user session.")
        public String[] additionalJcrPrivilegesForAdd() default {"jcr:read"};

        @AttributeDefinition(cardinality=100, name="Additional Jcr Privileges for Delete", description="Additional Jcr privileges to check for authorizing ADD distribution requests. The privilege is checked for the calling user session.")
        public String[] additionalJcrPrivilegesForDelete() default {"jcr:removeNode"};
    }
}

