/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.graphql.core.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class SlingGraphQLErrorHelper {
    public static final String GRAPHQL_ERROR_EXTENSIONS = "extensions";
    public static final String GRAPHQL_ERROR_MESSAGE = "message";
    public static final String GRAPHQL_ERROR_DETAIL = "detail";
    public static final String GRAPHQL_ERROR_EXCEPTION = "exception";
    public static final String GRAPHQL_ERROR_CAUSE = "cause";
    public static final String GRAPHQL_ERROR_CAUSE_STACKTRACE = "stacktrace";
    public static final String GRAPHQL_ERROR_ERRORS = "errors";
    public static int MAX_STACK_TRACE_DEPTH = 10;

    private SlingGraphQLErrorHelper() {
    }

    public static Map<String, Object> toSpecification(String customMessage, Exception e) {
        LinkedHashMap<String, Object> additionalExceptionInfo = new LinkedHashMap<String, Object>();
        additionalExceptionInfo.put(GRAPHQL_ERROR_MESSAGE, e.getMessage());
        LinkedHashMap<String, Object> extensionsMap = new LinkedHashMap<String, Object>();
        extensionsMap.put(GRAPHQL_ERROR_DETAIL, customMessage);
        extensionsMap.put(GRAPHQL_ERROR_EXCEPTION, e.getClass().getName());
        if (e.getCause() != null) {
            extensionsMap.put(GRAPHQL_ERROR_CAUSE, e.getCause().toString());
            ArrayList<String> stacktrace = new ArrayList<String>();
            for (int i = 0; i < e.getCause().getStackTrace().length && i < MAX_STACK_TRACE_DEPTH; ++i) {
                stacktrace.add(e.getCause().getStackTrace()[i].toString());
            }
            extensionsMap.put(GRAPHQL_ERROR_CAUSE_STACKTRACE, stacktrace);
        }
        additionalExceptionInfo.put(GRAPHQL_ERROR_EXTENSIONS, extensionsMap);
        ArrayList<LinkedHashMap<String, Object>> errorList = new ArrayList<LinkedHashMap<String, Object>>();
        errorList.add(0, additionalExceptionInfo);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(GRAPHQL_ERROR_ERRORS, errorList);
        return result;
    }
}

