/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.packaging.registry.impl;

import java.io.IOException;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.NoSuchPackageException;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.jackrabbit.vault.packaging.registry.PackageTaskOptions;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.jackrabbit.vault.packaging.registry.impl.ExecutionPlanImpl;
import org.apache.jackrabbit.vault.packaging.registry.impl.InternalPackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.taskoption.ImportOptionsPackageTaskOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageTaskImpl
implements PackageTask {
    private static final Logger log = LoggerFactory.getLogger(PackageTaskImpl.class);
    static final PackageTaskImpl MARKER = new PackageTaskImpl(new PackageId("", "", ""), PackageTask.Type.INSTALL, null);
    private final PackageId id;
    private final PackageTask.Type type;
    private final PackageTaskOptions options;
    PackageTask.State state = PackageTask.State.NEW;
    private Throwable error;

    PackageTaskImpl(@NotNull PackageId id, @NotNull PackageTask.Type type, @Nullable PackageTaskOptions options) {
        this.id = id;
        this.type = type;
        this.options = options;
    }

    @Override
    @NotNull
    public PackageId getPackageId() {
        return this.id;
    }

    @Override
    @NotNull
    public PackageTask.Type getType() {
        return this.type;
    }

    @Override
    @Nullable
    public PackageTaskOptions getOptions() {
        return this.options;
    }

    @Override
    @NotNull
    public PackageTask.State getState() {
        return this.state;
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return "PackageTaskImpl [" + (this.id != null ? "id=" + this.id + ", " : "") + (this.type != null ? "type=" + (Object)((Object)this.type) + ", " : "") + (this.options != null ? "option=" + this.options + ", " : "") + (this.state != null ? "state=" + (Object)((Object)this.state) + ", " : "") + (this.error != null ? "error=" + this.error : "") + "]";
    }

    void execute(ExecutionPlanImpl executionPlan) {
        if (this.state != PackageTask.State.NEW) {
            return;
        }
        this.state = PackageTask.State.RUNNING;
        try {
            switch (this.type) {
                case INSTALL: {
                    this.doInstall(executionPlan, false);
                    break;
                }
                case UNINSTALL: {
                    this.doUninstall(executionPlan);
                    break;
                }
                case REMOVE: {
                    this.doRemove(executionPlan);
                    break;
                }
                case EXTRACT: {
                    this.doInstall(executionPlan, true);
                }
            }
            this.state = PackageTask.State.COMPLETED;
        }
        catch (Exception e) {
            log.info("error during package task {} on {}: {}", new Object[]{this.type, this.id, e.toString()});
            this.error = e;
            this.state = PackageTask.State.ERROR;
        }
    }

    private void doRemove(ExecutionPlanImpl plan) throws IOException, PackageException {
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            if (pkg.isInstalled()) {
                throw new PackageException("refusing to remove installed package: " + this.id);
            }
            plan.getRegistry().remove(this.id);
        }
    }

    private void doUninstall(ExecutionPlanImpl plan) throws IOException, PackageException {
        ImportOptions opts = new ImportOptions();
        opts.setListener(plan.getListener());
        opts.setDependencyHandling(DependencyHandling.STRICT);
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            PackageRegistry registry = plan.getRegistry();
            if (registry instanceof InternalPackageRegistry) {
                ((InternalPackageRegistry)registry).uninstallPackage(plan.getSession(), pkg, opts);
            }
        }
    }

    private void doInstall(ExecutionPlanImpl plan, boolean extract) throws IOException, PackageException {
        ImportOptions opts = this.options instanceof ImportOptionsPackageTaskOption ? ((ImportOptionsPackageTaskOption)this.options).getImportOptions().copy() : new ImportOptions();
        opts.setListener(plan.getListener());
        opts.setDependencyHandling(DependencyHandling.STRICT);
        try (RegisteredPackage pkg = plan.getRegistry().open(this.id);){
            if (pkg == null) {
                throw new NoSuchPackageException("No such package: " + this.id);
            }
            PackageRegistry registry = plan.getRegistry();
            if (registry instanceof InternalPackageRegistry) {
                ((InternalPackageRegistry)registry).installPackage(plan.getSession(), pkg, opts, extract);
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.options == null ? 0 : this.options.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PackageTaskImpl other = (PackageTaskImpl)obj;
        if (this.error == null ? other.error != null : !this.error.equals(other.error)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.options == null ? other.options != null : !this.options.equals(other.options)) {
            return false;
        }
        if (this.state != other.state) {
            return false;
        }
        return this.type == other.type;
    }
}

