/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.it.testing.rtboundpicker;

import java.util.HashMap;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.junit.rules.TeleporterRule;
import org.apache.sling.models.it.testbundle.rtboundpicker.BaseComponent;
import org.apache.sling.models.it.testbundle.rtboundpicker.SubRTComponent;
import org.apache.sling.models.it.testbundle.rtboundpicker.TestComponent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ResourceTypePickerIT {
    @Rule
    public final TeleporterRule teleporter = TeleporterRule.forClass(this.getClass(), (String)"SM_Teleporter");
    private ResourceResolverFactory rrFactory;
    private final String baseComponentPath = "/content/rtpicker/baseComponent";
    private final String childComponentPath = "/content/rtpicker/childComponent";

    @Before
    public void setup() throws LoginException, PersistenceException {
        this.rrFactory = (ResourceResolverFactory)this.teleporter.getService(ResourceResolverFactory.class);
        try (ResourceResolver adminResolver = this.rrFactory.getServiceResourceResolver(null);){
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("sling:resourceType", "sling/rtpicker/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rtpicker/baseComponent", properties, null, (boolean)false);
            properties.clear();
            properties.put("sling:resourceType", "sling/rtpicker/sub");
            properties.put("sling:resourceSuperType", "sling/rtpicker/base");
            ResourceUtil.getOrCreateResource((ResourceResolver)adminResolver, (String)"/content/rtpicker/childComponent", properties, null, (boolean)false);
            properties.clear();
            adminResolver.commit();
        }
    }

    @Test
    public void testClientModelCreateFromResource() throws LoginException {
        try (ResourceResolver resolver = this.rrFactory.getServiceResourceResolver(null);){
            Resource baseComponentResource = resolver.getResource("/content/rtpicker/baseComponent");
            Assert.assertNotNull((Object)baseComponentResource);
            TestComponent baseModel = (TestComponent)baseComponentResource.adaptTo(TestComponent.class);
            Assert.assertNotNull((String)"Model should not be null", (Object)baseModel);
            Assert.assertTrue((String)"Model should be a BaseComponent", (boolean)(baseModel instanceof BaseComponent));
            Resource childComponentResource = resolver.getResource("/content/rtpicker/childComponent");
            Assert.assertNotNull((Object)childComponentResource);
            baseModel = (TestComponent)childComponentResource.adaptTo(TestComponent.class);
            Assert.assertNotNull((String)"Model should not be null", (Object)baseModel);
            Assert.assertTrue((String)"Model should be a SubRTComponent", (boolean)(baseModel instanceof SubRTComponent));
        }
    }
}

