/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.engine;

import org.apache.sling.scripting.sightly.extension.RuntimeExtension;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;

class RuntimeExtensionReference
implements Comparable<RuntimeExtensionReference> {
    private final int priority;
    private final String name;
    private final ServiceReference<RuntimeExtension> serviceReference;
    private final RuntimeExtension runtimeExtension;

    RuntimeExtensionReference(ServiceReference<RuntimeExtension> serviceReference, RuntimeExtension runtimeExtension) {
        this.serviceReference = serviceReference;
        this.runtimeExtension = runtimeExtension;
        Object ranking = serviceReference.getProperty("service.ranking");
        this.priority = ranking instanceof Integer ? (Integer)ranking : 0;
        this.name = (String)((Converting)Converters.standardConverter().convert(serviceReference.getProperty("org.apache.sling.scripting.sightly.extension.name")).defaultValue((Object)"")).to(String.class);
    }

    @Override
    public int compareTo(@NotNull RuntimeExtensionReference other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.name.equals(other.name)) {
            return this.priority - other.priority;
        }
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeExtensionReference) {
            RuntimeExtensionReference other = (RuntimeExtensionReference)obj;
            return this.serviceReference.equals(other.serviceReference);
        }
        return false;
    }

    public int hashCode() {
        return this.serviceReference.hashCode();
    }

    public String getName() {
        return this.name;
    }

    ServiceReference<RuntimeExtension> getServiceReference() {
        return this.serviceReference;
    }

    RuntimeExtension getService() {
        return this.runtimeExtension;
    }
}

