/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.junit.Assert;

public class SlingClient {
    public static final String LOCATION_HEADER = "Location";
    public static final String HTTP_PREFIX = "http://";
    private final RequestExecutor executor;
    private final RequestBuilder builder;
    private final String slingServerUrl;
    private final String username;
    private final String password;

    public SlingClient(String slingServerUrl, String username, String password) {
        this.slingServerUrl = slingServerUrl;
        this.username = username;
        this.password = password;
        this.builder = new RequestBuilder(slingServerUrl);
        this.executor = new RequestExecutor(new DefaultHttpClient());
    }

    public String createNode(String path, String ... properties) throws IOException {
        Map<String, Object> props = this.extractMap(properties);
        return this.createNode(path, props);
    }

    public String createNode(String path, Map<String, Object> properties) throws UnsupportedEncodingException, IOException {
        String actualPath = null;
        MultipartEntity entity = new MultipartEntity();
        entity.addPart(":redirect", (ContentBody)new StringBody("*"));
        entity.addPart(":displayExtension", (ContentBody)new StringBody(""));
        if (properties != null) {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                entity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValue().toString()));
            }
        }
        HttpResponse response = this.executor.execute(this.builder.buildPostRequest(path).withEntity((HttpEntity)entity).withCredentials(this.username, this.password)).assertStatus(302).getResponse();
        Header location = response.getFirstHeader(LOCATION_HEADER);
        Assert.assertNotNull((String)"Expecting Location in response", (Object)location);
        actualPath = this.locationToPath(location.getValue());
        return actualPath;
    }

    String locationToPath(String locationHeaderValue) {
        if (locationHeaderValue.startsWith(this.slingServerUrl)) {
            return locationHeaderValue.substring(this.slingServerUrl.length());
        }
        if (locationHeaderValue.startsWith(HTTP_PREFIX)) {
            throw new IllegalArgumentException("Unexpected Location header value [" + locationHeaderValue + "], should start with [" + this.slingServerUrl + "] if starting with " + HTTP_PREFIX);
        }
        return locationHeaderValue;
    }

    private Map<String, Object> extractMap(String[] properties) {
        HashMap<String, String> props = null;
        if (properties != null && properties.length > 0) {
            props = new HashMap<String, String>();
            if (properties.length % 2 != 0) {
                throw new IllegalArgumentException("Odd number of properties is invalid:" + properties.length);
            }
            for (int i = 0; i < properties.length; i += 2) {
                props.put(properties[i], properties[i + 1]);
            }
        }
        return props;
    }

    public void setProperties(String path, String ... properties) throws IOException {
        Map<String, Object> props = this.extractMap(properties);
        this.setProperties(path, props);
    }

    public void setProperties(String path, Map<String, Object> properties) throws IOException {
        MultipartEntity entity = new MultipartEntity();
        if (properties != null) {
            for (Map.Entry<String, Object> e : properties.entrySet()) {
                entity.addPart(e.getKey(), (ContentBody)new StringBody(e.getValue().toString()));
            }
        }
        HttpResponse response = this.executor.execute(this.builder.buildPostRequest(path).withEntity((HttpEntity)entity).withCredentials(this.username, this.password)).assertStatus(200).getResponse();
    }

    public void delete(String path) throws IOException {
        this.executor.execute(this.builder.buildOtherRequest((HttpRequestBase)new HttpDelete(this.builder.buildUrl(path, new String[0]))).withCredentials(this.username, this.password)).assertStatus(204);
    }

    public void upload(String path, InputStream data, int length, boolean createFolders) throws IOException {
        InputStreamEntity e = new InputStreamEntity(data, (long)length);
        if (createFolders) {
            this.mkdirs(this.getParentPath(path));
        }
        this.executor.execute(this.builder.buildOtherRequest((HttpRequestBase)new HttpPut(this.builder.buildUrl(path, new String[0]))).withEntity((HttpEntity)e).withCredentials(this.username, this.password)).assertStatus(201);
    }

    public void mkdirs(String path) throws IOException {
        Stack<String> parents = new Stack<String>();
        path = this.getParentPath(path);
        while (path.length() > 0 && !this.exists(path)) {
            parents.push(path);
            path = this.getParentPath(path);
        }
        while (!parents.isEmpty()) {
            this.mkdir((String)parents.pop());
        }
    }

    public void mkdir(String path) throws IOException {
        if (!this.exists(path)) {
            this.executor.execute(this.builder.buildOtherRequest(new HttpAnyMethod("MKCOL", this.builder.buildUrl(path, new String[0]))).withCredentials(this.username, this.password)).assertStatus(201);
        }
    }

    public boolean exists(String path) throws IOException {
        int status = this.executor.execute(this.builder.buildGetRequest(path + ".json", new String[0]).withCredentials(this.username, this.password)).getResponse().getStatusLine().getStatusCode();
        return status == 200;
    }

    protected String getParentPath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            return path.substring(0, pos);
        }
        return "";
    }

    static class HttpAnyMethod
    extends HttpRequestBase {
        private final URI uri;
        private final String method;

        HttpAnyMethod(String method, String uriString) {
            this.uri = URI.create(uriString);
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }

        public URI getURI() {
            return this.uri;
        }
    }
}

