/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.r;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Arrays;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.api.r.BufferedStreamThread;
import org.apache.spark.api.r.RRunnerModes$;
import org.apache.spark.api.r.RUtils$;
import org.apache.spark.api.r.SparkRDefaults$;
import org.apache.spark.util.Utils$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class RRunner$ {
    public static final RRunner$ MODULE$;
    private BufferedStreamThread errThread;
    private DataOutputStream daemonChannel;

    static {
        new RRunner$();
    }

    /*
     * WARNING - void declaration
     */
    private BufferedStreamThread startStdoutThread(Process proc) {
        void var3_3;
        int BUFFER_SIZE = 100;
        BufferedStreamThread thread = new BufferedStreamThread(proc.getInputStream(), "stdout reader for R", BUFFER_SIZE);
        thread.setDaemon(true);
        thread.start();
        return var3_3;
    }

    private BufferedStreamThread createRProcess(int port, String script) {
        SparkConf sparkConf = SparkEnv$.MODULE$.get().conf();
        String rCommand = sparkConf.get("spark.sparkr.r.command", "Rscript");
        rCommand = sparkConf.get("spark.r.command", rCommand);
        int rConnectionTimeout = sparkConf.getInt("spark.r.backendConnectionTimeout", SparkRDefaults$.MODULE$.DEFAULT_CONNECTION_TIMEOUT());
        String rOptions = "--vanilla";
        Seq<String> rLibDir = RUtils$.MODULE$.sparkRPackagePath(false);
        String rExecScript = new StringBuilder().append((Object)((String)rLibDir.apply(0))).append((Object)"/SparkR/worker/").append((Object)script).toString();
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList((Object[])new String[]{rCommand, rOptions, rExecScript}));
        pb.environment().put("R_TESTS", "");
        pb.environment().put("SPARKR_RLIBDIR", rLibDir.mkString(","));
        pb.environment().put("SPARKR_WORKER_PORT", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        pb.environment().put("SPARKR_BACKEND_CONNECTION_TIMEOUT", ((Object)BoxesRunTime.boxToInteger((int)rConnectionTimeout)).toString());
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedStreamThread errThread = this.startStdoutThread(proc);
        return errThread;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedStreamThread createRWorker(int port) {
        BufferedStreamThread bufferedStreamThread;
        boolean useDaemon = SparkEnv$.MODULE$.get().conf().getBoolean("spark.sparkr.use.daemon", true);
        if (!Utils$.MODULE$.isWindows() && useDaemon) {
            RRunner$ rRunner$ = this;
            synchronized (rRunner$) {
                if (this.daemonChannel == null) {
                    ServerSocket serverSocket = new ServerSocket(0, 1, InetAddress.getByName("localhost"));
                    int daemonPort = serverSocket.getLocalPort();
                    this.errThread = this.createRProcess(daemonPort, "daemon.R");
                    serverSocket.setSoTimeout(10000);
                    Socket sock = serverSocket.accept();
                    this.daemonChannel = new DataOutputStream(new BufferedOutputStream(sock.getOutputStream()));
                    serverSocket.close();
                }
                this.liftedTree1$1(port);
                BufferedStreamThread bufferedStreamThread2 = this.errThread;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : rRunner$
                bufferedStreamThread = bufferedStreamThread2;
                return bufferedStreamThread;
            }
        }
        bufferedStreamThread = this.createRProcess(port, "worker.R");
        return bufferedStreamThread;
    }

    public <U> int $lessinit$greater$default$6() {
        return -1;
    }

    public <U> boolean $lessinit$greater$default$7() {
        return false;
    }

    public <U> String[] $lessinit$greater$default$8() {
        return null;
    }

    public <U> int $lessinit$greater$default$9() {
        return RRunnerModes$.MODULE$.RDD();
    }

    private final void liftedTree1$1(int port$1) {
        try {
            this.daemonChannel.writeInt(port$1);
            this.daemonChannel.flush();
            return;
        }
        catch (IOException iOException) {
            this.daemonChannel.close();
            this.daemonChannel = null;
            this.errThread = null;
            throw iOException;
        }
    }

    private RRunner$() {
        MODULE$ = this;
    }
}

