/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.specific;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.FooBarSpecificRecord;
import org.apache.avro.Schema;
import org.apache.avro.TestSchema;
import org.apache.avro.TypeEnum;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.test.Kind;
import org.apache.avro.test.MD5;
import org.apache.avro.test.TestRecord;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class TestSpecificData {
    @Test
    public void testHashCode() {
        new TestRecord().hashCode();
        SpecificData.get().hashCode(null, TestRecord.SCHEMA$);
    }

    @Test
    public void testToString() {
        new TestRecord().toString();
    }

    @Test
    public void testGetMapSchema() throws Exception {
        SpecificData.get().getSchema(X.class.getField("map").getGenericType());
    }

    @Test
    public void testSpecificWithinGeneric() throws Exception {
        Schema schema = Schema.createRecord((String)"Foo", (String)"", (String)"x.y.z", (boolean)false);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        fields.add(new Schema.Field("f", TestRecord.SCHEMA$, "", null));
        schema.setFields(fields);
        TestRecord nested = new TestRecord();
        nested.setName("foo");
        nested.setKind(Kind.BAR);
        nested.setHash(new MD5(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5}));
        GenericData.Record record = new GenericData.Record(schema);
        record.put("f", (Object)nested);
        TestSchema.checkBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
        TestSchema.checkDirectBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
        TestSchema.checkBlockingBinary(schema, record, (DatumWriter<Object>)new SpecificDatumWriter(), (DatumReader<Object>)new SpecificDatumReader());
    }

    @Test
    public void testGetClassSchema() throws Exception {
        Assert.assertEquals((Object)TestRecord.getClassSchema(), (Object)TestRecord.SCHEMA$);
        Assert.assertEquals((Object)MD5.getClassSchema(), (Object)MD5.SCHEMA$);
        Assert.assertEquals((Object)Kind.getClassSchema(), (Object)Kind.SCHEMA$);
    }

    @Test
    public void testSpecificRecordToString() throws IOException {
        FooBarSpecificRecord foo = FooBarSpecificRecord.newBuilder().setId(123).setName("foo").setNicknames(Arrays.asList("bar")).setRelatedids(Arrays.asList(1, 2, 3)).setTypeEnum(TypeEnum.c).build();
        String json = foo.toString();
        JsonFactory factory = new JsonFactory();
        JsonParser parser = factory.createJsonParser(json);
        ObjectMapper mapper = new ObjectMapper();
        mapper.readTree(parser);
    }

    private static class X {
        public Map<String, String> map;

        private X() {
        }
    }
}

