/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.workload;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.workload.Op;
import org.apache.sysds.runtime.compress.workload.WTreeNode;

public abstract class AWTreeNode {
    protected static final Log LOG = LogFactory.getLog((String)AWTreeNode.class.getName());
    private final WTNodeType _type;
    protected final List<WTreeNode> _children = new ArrayList<WTreeNode>();
    protected final List<Op> _ops = new ArrayList<Op>();

    public AWTreeNode(WTNodeType type) {
        this._type = type;
    }

    public WTNodeType getType() {
        return this._type;
    }

    public List<WTreeNode> getChildNodes() {
        return this._children;
    }

    public void addChild(WTreeNode node) {
        this._children.add(node);
    }

    public List<Op> getOps() {
        return this._ops;
    }

    public void addOp(Op op) {
        this._ops.add(op);
    }

    public boolean isEmpty() {
        return this._ops.isEmpty() && this._children.isEmpty();
    }

    protected String explain(int level) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            sb.append("--");
        }
        sb.append(this._type.name());
        sb.append("\n");
        for (Op op : this._ops) {
            for (int i = 0; i < level + 1; ++i) {
                sb.append("--");
            }
            sb.append(op.toString());
            sb.append("\n");
        }
        if (!this._children.isEmpty()) {
            for (AWTreeNode aWTreeNode : this._children) {
                sb.append(aWTreeNode.explain(level + 1));
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n---------------------------Workload Tree:---------------------------------------\n");
        sb.append(this.explain(0));
        sb.append("--------------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public static enum WTNodeType {
        ROOT,
        FCALL,
        IF,
        WHILE,
        FOR,
        PARFOR,
        BASIC_BLOCK;


        public boolean isLoop() {
            return this == WHILE || this == FOR || this == PARFOR;
        }
    }
}

