/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark.functions;

import org.apache.spark.api.java.function.PairFunction;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.functionobjects.DiagIndex;
import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.functionobjects.SwapIndex;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import scala.Tuple2;

public class ReorgMapFunction
implements PairFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
    private static final long serialVersionUID = 31065772250744103L;
    private ReorgOperator _reorgOp = null;
    private IndexFunction _indexFnObject = null;

    public ReorgMapFunction(String opcode) {
        if (opcode.equalsIgnoreCase("r'")) {
            this._indexFnObject = SwapIndex.getSwapIndexFnObject();
        } else if (opcode.equalsIgnoreCase("rdiag")) {
            this._indexFnObject = DiagIndex.getDiagIndexFnObject(false);
        } else {
            throw new DMLRuntimeException("Incorrect opcode for RDDReorgMapFunction:" + opcode);
        }
        this._reorgOp = new ReorgOperator(this._indexFnObject);
    }

    public Tuple2<MatrixIndexes, MatrixBlock> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
        MatrixIndexes ixIn = (MatrixIndexes)arg0._1();
        MatrixBlock blkIn = (MatrixBlock)arg0._2();
        MatrixIndexes ixOut = new MatrixIndexes(ixIn);
        this._indexFnObject.execute(ixIn, ixOut);
        MatrixBlock blkOut = blkIn.reorgOperations(this._reorgOp, new MatrixBlock(), -1, -1, -1);
        return new Tuple2((Object)ixOut, (Object)blkOut);
    }
}

