/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim.encoding;

import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.AEncode;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;

public class ConstEncoding
extends AEncode {
    private final int[] counts;

    protected ConstEncoding(int nRows) {
        this.counts = new int[]{nRows};
    }

    @Override
    public IEncode combine(IEncode e) {
        return e;
    }

    @Override
    public Pair<IEncode, Map<Integer, Integer>> combineWithMap(IEncode e) {
        return new ImmutablePair((Object)e, null);
    }

    @Override
    public int getUnique() {
        return 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        return sb.toString();
    }

    @Override
    public EstimationFactors extractFacts(int nRows, double tupleSparsity, double matrixSparsity, CompressionSettings cs) {
        return new EstimationFactors(1, nRows, nRows, this.counts, 0, nRows, 1, false, false, matrixSparsity, tupleSparsity);
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean equals(IEncode e) {
        return e instanceof ConstEncoding && ((ConstEncoding)e).counts.length == this.counts.length;
    }
}

