/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;

public class CombinedIndex
extends AColIndex {
    protected final IColIndex l;
    protected final IColIndex r;

    public CombinedIndex(IColIndex l, IColIndex r) {
        this.l = l;
        this.r = r;
    }

    @Override
    public int size() {
        return this.l.size() + this.r.size();
    }

    @Override
    public int get(int i) {
        if (i >= this.l.size()) {
            return this.r.get(i - this.l.size());
        }
        return this.l.get(i);
    }

    @Override
    public IColIndex shift(int i) {
        return new CombinedIndex(this.l.shift(i), this.r.shift(i));
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.write(IColIndex.ColIndexType.COMBINED.ordinal());
        this.l.write(out);
        this.r.write(out);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 1L + this.l.getExactSizeOnDisk() + this.r.getExactSizeOnDisk();
    }

    @Override
    public long estimateInMemorySize() {
        return 32L + this.l.estimateInMemorySize() + this.r.estimateInMemorySize();
    }

    @Override
    public IIterate iterator() {
        return new CombinedIterator();
    }

    @Override
    public int findIndex(int i) {
        int a = this.l.findIndex(i);
        if (a < 0) {
            int b = this.r.findIndex(i);
            if (b < 0) {
                return b + a + 1;
            }
            return b + this.l.size();
        }
        return a;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        return this.getArrayIndex().slice(l, u);
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other == this) {
            return true;
        }
        if (this.size() == other.size()) {
            if (other instanceof CombinedIndex) {
                CombinedIndex o = (CombinedIndex)other;
                return o.l.equals(this.l) && o.r.equals(this.r);
            }
            IIterate t = this.iterator();
            IIterate o = other.iterator();
            while (t.hasNext()) {
                if (t.next() == o.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IColIndex combine(IColIndex other) {
        int minCombined;
        int maxCombined;
        int sl;
        int sr = other.size();
        if (sr + (sl = this.size()) == (maxCombined = Math.max(this.get(this.size() - 1), other.get(other.size() - 1))) - (minCombined = Math.min(this.get(0), other.get(0))) + 1) {
            return new RangeIndex(minCombined, maxCombined + 1);
        }
        int[] ret = new int[sr + sl];
        IIterate t = this.iterator();
        IIterate o = other.iterator();
        int i = 0;
        while (t.hasNext() && o.hasNext()) {
            int ov;
            int tv = t.v();
            if (tv < (ov = o.v())) {
                ret[i++] = tv;
                t.next();
                continue;
            }
            ret[i++] = ov;
            o.next();
        }
        while (t.hasNext()) {
            ret[i++] = t.next();
        }
        while (o.hasNext()) {
            ret[i++] = o.next();
        }
        return ColIndexFactory.create(ret);
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public int[] getReorderingIndex() {
        return this.getArrayIndex().getReorderingIndex();
    }

    @Override
    public boolean isSorted() {
        return true;
    }

    @Override
    public IColIndex sort() {
        throw new DMLCompressionException("CombinedIndex is always sorted");
    }

    @Override
    public boolean contains(int i) {
        return this.l.contains(i) || this.r.contains(i);
    }

    @Override
    public double avgOfIndex() {
        double lv = this.l.avgOfIndex() * (double)this.l.size();
        double rv = this.r.avgOfIndex() * (double)this.r.size();
        return (lv + rv) / (double)this.size();
    }

    private IColIndex getArrayIndex() {
        int s = this.size();
        int[] vals = new int[s];
        IIterate a = this.iterator();
        for (int i = 0; i < s; ++i) {
            vals[i] = a.next();
        }
        return ColIndexFactory.create(vals);
    }

    public static CombinedIndex read(DataInput in) throws IOException {
        return new CombinedIndex(ColIndexFactory.read(in), ColIndexFactory.read(in));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append(this.l);
        sb.append(", ");
        sb.append(this.r);
        sb.append("]");
        return sb.toString();
    }

    protected class CombinedIterator
    implements IIterate {
        boolean doneFirst = false;
        IIterate I;

        protected CombinedIterator() {
            this.I = CombinedIndex.this.l.iterator();
        }

        @Override
        public int next() {
            int v = this.I.next();
            if (!this.I.hasNext() && !this.doneFirst) {
                this.doneFirst = true;
                this.I = CombinedIndex.this.r.iterator();
            }
            return v;
        }

        @Override
        public boolean hasNext() {
            return this.I.hasNext() || !this.doneFirst;
        }

        @Override
        public int v() {
            return this.I.v();
        }

        @Override
        public int i() {
            if (this.doneFirst) {
                return this.I.i() + CombinedIndex.this.l.size();
            }
            return this.I.i();
        }
    }
}

