/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.rdd;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.InputSplitWithLocationInfo;
import org.apache.hadoop.mapred.InvalidInputException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.lib.CombineFileSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.spark.Dependency;
import org.apache.spark.InterruptibleIterator;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.errors.SparkCoreErrors$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rdd.HadoopPartition;
import org.apache.spark.rdd.HadoopRDD$;
import org.apache.spark.rdd.InputFileBlockHolder$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.NextIterator;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\r]c\u0001\u0002\u001f>\u0001\u0019C\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u001a\u0005\tW\u0002\u0011\t\u0011)A\u0005Y\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010\u0003\u0006\u0002\u0016\u0001\u0011\t\u0011)A\u0005\u0003/A!\"!\u0010\u0001\u0005\u0003\u0005\u000b\u0011BA \u0011)\t\t\u0005\u0001B\u0001B\u0003%\u00111\t\u0005\u000b\u0003\u000b\u0002!\u0011!Q\u0001\n\u0005\u001d\u0003bBA'\u0001\u0011\u0005\u0011q\n\u0005\b\u0003\u001b\u0002A\u0011AA5\u0011%\t\u0019\t\u0001b\u0001\n#\t)\t\u0003\u0005\u0002\u000e\u0002\u0001\u000b\u0011BAD\u0011%\ty\t\u0001b\u0001\n#\t)\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAD\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)\n\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAL\u0011%\t9\u000b\u0001b\u0001\n\u0013\tI\u000b\u0003\u0005\u00022\u0002\u0001\u000b\u0011BAV\u0011%\t\u0019\f\u0001b\u0001\n\u0013\tI\u000b\u0003\u0005\u00026\u0002\u0001\u000b\u0011BAV\u0011%\t9\f\u0001b\u0001\n\u0013\tI\u000b\u0003\u0005\u0002:\u0002\u0001\u000b\u0011BAV\u0011%\tY\f\u0001b\u0001\n\u0013\tI\u000b\u0003\u0005\u0002>\u0002\u0001\u000b\u0011BAV\u0011\u001d\ty\f\u0001C\t\u0003\u0003Dq!a1\u0001\t#\t)\rC\u0004\u0002J\u0002!\t%a3\t\u000f\u0005e\u0007\u0001\"\u0011\u0002\\\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\b\"\u0003B$\u0001E\u0005I\u0011\u0001B%\u0011\u001d\u0011\t\u0007\u0001C!\u0005GBqAa\u001c\u0001\t\u0003\u0012\t\bC\u0004\u0003t\u0001!\tE!\u001e\t\u000f\t%\u0005\u0001\"\u0001\u0003\f\u001eA!\u0011T\u001f\t\u0002}\u0012YJB\u0004={!\u0005qH!(\t\u000f\u000553\u0005\"\u0001\u0003,\"I!QV\u0012C\u0002\u0013\u0005!q\u0016\u0005\t\u0005{\u001b\u0003\u0015!\u0003\u00032\"9!qX\u0012\u0005\u0002\t\u0005\u0007b\u0002BdG\u0011%!\u0011\u001a\u0005\b\u0005#\u001cC\u0011\u0001Bj\r\u001d\u00119o\t\u0001@\u0005SD!Ba=+\u0005\u0003\u0005\u000b\u0011\u0002B{\u0011)\u0011\u0019B\u000bB\u0001B\u0003%!Q \u0005\u000b\u0005oQ#\u0011!Q\u0001\n\u0005-\u0006BCB\u0002U\t\r\t\u0015a\u0003\u0004\u0006!Q1q\u0001\u0016\u0003\u0004\u0003\u0006Ya!\u0003\t\u000f\u00055#\u0006\"\u0001\u0004\f!I1Q\u0004\u0016C\u0002\u0013\u00053q\u0004\u0005\t\u0007SQ\u0003\u0015!\u0003\u0004\"!9\u0011\u0011\u001a\u0016\u0005B\u0005-\u0007bBAmU\u0011\u000531F\u0004\u000b\u0007c\u0019\u0013\u0011!E\u0001\u007f\rMbA\u0003BtG\u0005\u0005\t\u0012A \u00046!9\u0011Q\n\u001c\u0005\u0002\r]\u0002\"CB\u001dmE\u0005I\u0011AB\u001e\u0011%\u0019\tENA\u0001\n\u0013\u0019\u0019\u0005\u0003\u0005\u0004F\r\"\taPB$\u0011%\u0019\teIA\u0001\n\u0013\u0019\u0019EA\u0005IC\u0012|w\u000e\u001d*E\t*\u0011ahP\u0001\u0004e\u0012$'B\u0001!B\u0003\u0015\u0019\b/\u0019:l\u0015\t\u00115)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\t\u0006\u0019qN]4\u0004\u0001U\u0019q\t\u00160\u0014\u0007\u0001A\u0005\rE\u0002J\u00152k\u0011!P\u0005\u0003\u0017v\u00121A\u0015#E!\u0011i\u0005KU/\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a\u0001V;qY\u0016\u0014\u0004CA*U\u0019\u0001!Q!\u0016\u0001C\u0002Y\u0013\u0011aS\t\u0003/j\u0003\"!\u0014-\n\u0005es%a\u0002(pi\"Lgn\u001a\t\u0003\u001bnK!\u0001\u0018(\u0003\u0007\u0005s\u0017\u0010\u0005\u0002T=\u0012)q\f\u0001b\u0001-\n\ta\u000b\u0005\u0002bI6\t!M\u0003\u0002d\u007f\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002fE\n9Aj\\4hS:<\u0017AA:d!\tA\u0017.D\u0001@\u0013\tQwH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/A\bce>\fGmY1ti\u0016$7i\u001c8g!\ri\u0007O]\u0007\u0002]*\u0011qnP\u0001\nEJ|\u0017\rZ2bgRL!!\u001d8\u0003\u0013\t\u0013x.\u00193dCN$\bCA:w\u001b\u0005!(BA;@\u0003\u0011)H/\u001b7\n\u0005]$(!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\fq#\u001b8ji2{7-\u00197K_\n\u001cuN\u001c4Gk:\u001cw\n\u001d;\u0011\u00075SH0\u0003\u0002|\u001d\n1q\n\u001d;j_:\u0004R!T?\u0000\u0003\u001fI!A (\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0007[\u0006\u0004(/\u001a3\u000b\u0007\u0005%\u0011)\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u001b\t\u0019AA\u0004K_\n\u001cuN\u001c4\u0011\u00075\u000b\t\"C\u0002\u0002\u00149\u0013A!\u00168ji\u0006\u0001\u0012N\u001c9vi\u001a{'/\\1u\u00072\f7o\u001d\u0019\u0005\u00033\t\t\u0004\u0005\u0004\u0002\u001c\u0005%\u0012q\u0006\b\u0005\u0003;\t)\u0003E\u0002\u0002 9k!!!\t\u000b\u0007\u0005\rR)\u0001\u0004=e>|GOP\u0005\u0004\u0003Oq\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"!B\"mCN\u001c(bAA\u0014\u001dB\u00191+!\r\u0005\u0017\u0005MB!!A\u0001\u0002\u000b\u0005\u0011Q\u0007\u0002\u0004?\u0012\n\u0014cA,\u00028A1\u0011\u0011AA\u001d%vKA!a\u000f\u0002\u0004\tY\u0011J\u001c9vi\u001a{'/\\1u\u0003!YW-_\"mCN\u001c\b#BA\u000e\u0003S\u0011\u0016A\u0003<bYV,7\t\\1tgB)\u00111DA\u0015;\u0006iQ.\u001b8QCJ$\u0018\u000e^5p]N\u00042!TA%\u0013\r\tYE\u0014\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\t\u0002R\u0005M\u0013QKA,\u00033\n\u0019'!\u001a\u0002hA!\u0011\n\u0001*^\u0011\u00151\u0007\u00021\u0001h\u0011\u0015Y\u0007\u00021\u0001m\u0011\u0015A\b\u00021\u0001z\u0011\u001d\t)\u0002\u0003a\u0001\u00037\u0002D!!\u0018\u0002bA1\u00111DA\u0015\u0003?\u00022aUA1\t1\t\u0019$!\u0017\u0002\u0002\u0003\u0005)\u0011AA\u001b\u0011\u001d\ti\u0004\u0003a\u0001\u0003\u007fAq!!\u0011\t\u0001\u0004\t\u0019\u0005C\u0004\u0002F!\u0001\r!a\u0012\u0015\u001d\u0005E\u00131NA7\u0003c\ni(a \u0002\u0002\")a-\u0003a\u0001O\"1\u0011qN\u0005A\u0002}\fAaY8oM\"9\u0011QC\u0005A\u0002\u0005M\u0004\u0007BA;\u0003s\u0002b!a\u0007\u0002*\u0005]\u0004cA*\u0002z\u0011a\u00111PA9\u0003\u0003\u0005\tQ!\u0001\u00026\t\u0019q\f\n\u001a\t\u000f\u0005u\u0012\u00021\u0001\u0002@!9\u0011\u0011I\u0005A\u0002\u0005\r\u0003bBA#\u0013\u0001\u0007\u0011qI\u0001\u0010U>\u00147i\u001c8g\u0007\u0006\u001c\u0007.Z&fsV\u0011\u0011q\u0011\t\u0005\u00037\tI)\u0003\u0003\u0002\f\u00065\"AB*ue&tw-\u0001\tk_\n\u001cuN\u001c4DC\u000eDWmS3zA\u0005\u0019\u0012N\u001c9vi\u001a{'/\\1u\u0007\u0006\u001c\u0007.Z&fs\u0006!\u0012N\u001c9vi\u001a{'/\\1u\u0007\u0006\u001c\u0007.Z&fs\u0002\n!b\u0019:fCR,G+[7f+\t\t9\n\u0005\u0003\u0002\u001a\u0006\u0005VBAAN\u0015\r)\u0018Q\u0014\u0006\u0003\u0003?\u000bAA[1wC&!\u00111UAN\u0005\u0011!\u0015\r^3\u0002\u0017\r\u0014X-\u0019;f)&lW\rI\u0001\u0013g\"|W\u000f\u001c3DY>tWMS8c\u0007>tg-\u0006\u0002\u0002,B\u0019Q*!,\n\u0007\u0005=fJA\u0004C_>dW-\u00198\u0002'MDw.\u001e7e\u00072|g.\u001a&pE\u000e{gN\u001a\u0011\u0002%%<gn\u001c:f\u0007>\u0014(/\u001e9u\r&dWm]\u0001\u0014S\u001etwN]3D_J\u0014X\u000f\u001d;GS2,7\u000fI\u0001\u0013S\u001etwN]3NSN\u001c\u0018N\\4GS2,7/A\njO:|'/Z'jgNLgn\u001a$jY\u0016\u001c\b%A\tjO:|'/Z#naRL8\u000b\u001d7jiN\f!#[4o_J,W)\u001c9usN\u0003H.\u001b;tA\u0005Qq-\u001a;K_\n\u001cuN\u001c4\u0015\u0003}\fabZ3u\u0013:\u0004X\u000f\u001e$pe6\fG\u000f\u0006\u0003\u00028\u0005\u001d\u0007BBA83\u0001\u0007q0A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003\u001b\u0004R!TAh\u0003'L1!!5O\u0005\u0015\t%O]1z!\rA\u0017Q[\u0005\u0004\u0003/|$!\u0003)beRLG/[8o\u0003\u001d\u0019w.\u001c9vi\u0016$b!!8\u0002d\u0006\u001d\b\u0003\u00025\u0002`2K1!!9@\u0005UIe\u000e^3seV\u0004H/\u001b2mK&#XM]1u_JDq!!:\u001c\u0001\u0004\t\u0019.\u0001\u0005uQ\u0016\u001c\u0006\u000f\\5u\u0011\u001d\tIo\u0007a\u0001\u0003W\fqaY8oi\u0016DH\u000fE\u0002i\u0003[L1!a<@\u0005-!\u0016m]6D_:$X\r\u001f;\u000275\f\u0007\u000fU1si&$\u0018n\u001c8t/&$\b.\u00138qkR\u001c\u0006\u000f\\5u+\u0011\t)0!@\u0015\r\u0005](\u0011\u0003B\u001b)\u0011\tIP!\u0001\u0011\t%S\u00151 \t\u0004'\u0006uHABA\u00009\t\u0007aKA\u0001V\u0011%\u0011\u0019\u0001HA\u0001\u0002\b\u0011)!\u0001\u0006fm&$WM\\2fIE\u0002bAa\u0002\u0003\u000e\u0005mXB\u0001B\u0005\u0015\r\u0011YAT\u0001\be\u00164G.Z2u\u0013\u0011\u0011yA!\u0003\u0003\u0011\rc\u0017m]:UC\u001eDqAa\u0005\u001d\u0001\u0004\u0011)\"A\u0001g!%i%q\u0003B\u000e\u0005C\u0011\u0019$C\u0002\u0003\u001a9\u0013\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0005\u0005!QD\u0005\u0005\u0005?\t\u0019A\u0001\u0006J]B,Ho\u00159mSR\u0004RAa\t\u0003.1sAA!\n\u0003*9!\u0011q\u0004B\u0014\u0013\u0005y\u0015b\u0001B\u0016\u001d\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u0018\u0005c\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0005Wq\u0005C\u0002B\u0012\u0005[\tY\u0010C\u0005\u00038q\u0001\n\u00111\u0001\u0002,\u0006)\u0002O]3tKJ4Xm\u001d)beRLG/[8oS:<\u0007f\u0001\u000f\u0003<A!!Q\bB\"\u001b\t\u0011yDC\u0002\u0003B}\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011)Ea\u0010\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5\u0002K5\f\u0007\u000fU1si&$\u0018n\u001c8t/&$\b.\u00138qkR\u001c\u0006\u000f\\5uI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002B&\u0005?*\"A!\u0014+\t\u0005-&qJ\u0016\u0003\u0005#\u0002BAa\u0015\u0003\\5\u0011!Q\u000b\u0006\u0005\u0005/\u0012I&A\u0005v]\u000eDWmY6fI*\u0019!\u0011\t(\n\t\tu#Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GABA\u0000;\t\u0007a+A\u000bhKR\u0004&/\u001a4feJ,G\rT8dCRLwN\\:\u0015\t\t\u0015$1\u000e\t\u0007\u0005G\u00119'a\"\n\t\t%$\u0011\u0007\u0002\u0004'\u0016\f\bb\u0002B7=\u0001\u0007\u00111[\u0001\u0006gBd\u0017\u000e^\u0001\u000bG\",7m\u001b9pS:$HCAA\b\u0003\u001d\u0001XM]:jgR$BAa\u001e\u0003z5\t\u0001\u0001C\u0004\u0003|\u0001\u0002\rA! \u0002\u0019M$xN]1hK2+g/\u001a7\u0011\t\t}$QQ\u0007\u0003\u0005\u0003S1Aa!@\u0003\u001d\u0019Ho\u001c:bO\u0016LAAa\"\u0003\u0002\na1\u000b^8sC\u001e,G*\u001a<fY\u00069q-\u001a;D_:4WC\u0001BG!\u0011\u0011yIa%\u000e\u0005\tE%\u0002BA8\u0003\u000fIAA!&\u0003\u0012\ni1i\u001c8gS\u001e,(/\u0019;j_:D3\u0001\u0001B\u001e\u0003%A\u0015\rZ8paJ#E\t\u0005\u0002JGM11Ea(a\u0005K\u00032!\u0014BQ\u0013\r\u0011\u0019K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u00075\u00139+C\u0002\u0003*:\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"Aa'\u0002A\r{eJR%H+J\u000bE+S(O?&s5\u000bV!O)&\u000bE+S(O?2{5iS\u000b\u0003\u0005c\u0003BAa-\u0003:6\u0011!Q\u0017\u0006\u0005\u0005o\u000bi*\u0001\u0003mC:<\u0017\u0002\u0002B^\u0005k\u0013aa\u00142kK\u000e$\u0018!I\"P\u001d\u001aKu)\u0016*B)&{ejX%O'R\u000be\nV%B)&{ej\u0018'P\u0007.\u0003\u0013!E4fi\u000e\u000b7\r[3e\u001b\u0016$\u0018\rZ1uCR!!q\u0014Bb\u0011\u001d\u0011)m\na\u0001\u0003\u000f\u000b1a[3z\u0003E\u0001X\u000f^\"bG\",G-T3uC\u0012\fG/\u0019\u000b\u0007\u0003\u001f\u0011YM!4\t\u000f\t\u0015\u0007\u00061\u0001\u0002\b\"9!q\u001a\u0015A\u0002\t}\u0015!\u0002<bYV,\u0017!F1eI2{7-\u00197D_:4\u0017nZ;sCRLwN\u001c\u000b\r\u0003\u001f\u0011)N!7\u0003^\n\u0005(Q\u001d\u0005\b\u0005/L\u0003\u0019AAD\u00031QwN\u0019+sC\u000e\\WM]%e\u0011\u001d\u0011Y.\u000ba\u0001\u0003\u000f\nQA[8c\u0013\u0012DqAa8*\u0001\u0004\t9%A\u0004ta2LG/\u00133\t\u000f\t\r\u0018\u00061\u0001\u0002H\u0005I\u0011\r\u001e;f[B$\u0018\n\u001a\u0005\u0007\u0003_J\u0003\u0019A@\u0003?!\u000bGm\\8q\u001b\u0006\u0004\b+\u0019:uSRLwN\\:XSRD7\u000b\u001d7jiJ#E)\u0006\u0004\u0003l\nE(\u0011`\n\u0004U\t5\b\u0003B%K\u0005_\u00042a\u0015By\t\u0019\tyP\u000bb\u0001-\u0006!\u0001O]3w!\u0011I%Ja>\u0011\u0007M\u0013I\u0010\u0002\u0004\u0003|*\u0012\rA\u0016\u0002\u0002)BIQJa\u0006\u0003\u001c\t}8\u0011\u0001\t\u0007\u0005G\u0011iCa>\u0011\r\t\r\"Q\u0006Bx\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0005\u000f\u0011iAa<\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0004\u0003\b\t5!q\u001f\u000b\t\u0007\u001b\u00199b!\u0007\u0004\u001cQ11qBB\n\u0007+\u0001ra!\u0005+\u0005_\u001490D\u0001$\u0011\u001d\u0019\u0019\u0001\ra\u0002\u0007\u000bAqaa\u00021\u0001\b\u0019I\u0001C\u0004\u0003tB\u0002\rA!>\t\u000f\tM\u0001\u00071\u0001\u0003~\"I!q\u0007\u0019\u0011\u0002\u0003\u0007\u00111V\u0001\fa\u0006\u0014H/\u001b;j_:,'/\u0006\u0002\u0004\"A!QJ_B\u0012!\rA7QE\u0005\u0004\u0007Oy$a\u0003)beRLG/[8oKJ\fA\u0002]1si&$\u0018n\u001c8fe\u0002\"ba!\u0001\u0004.\r=\u0002b\u0002B7i\u0001\u0007\u00111\u001b\u0005\b\u0003S$\u0004\u0019AAv\u0003}A\u0015\rZ8pa6\u000b\u0007\u000fU1si&$\u0018n\u001c8t/&$\bn\u00159mSR\u0014F\t\u0012\t\u0004\u0007#14#\u0002\u001c\u0003 \n\u0015FCAB\u001a\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU1!1JB\u001f\u0007\u007f!a!a@9\u0005\u00041FA\u0002B~q\t\u0007a+A\u0006sK\u0006$'+Z:pYZ,GC\u0001BY\u0003a\u0019wN\u001c<feR\u001c\u0006\u000f\\5u\u0019>\u001c\u0017\r^5p]&sgm\u001c\u000b\u0005\u0007\u0013\u001aY\u0005\u0005\u0003Nu\n\u0015\u0004bBB'u\u0001\u00071qJ\u0001\u0006S:4wn\u001d\t\u0006\u001b\u0006=7\u0011\u000b\t\u0005\u0003\u0003\u0019\u0019&\u0003\u0003\u0004V\u0005\r!!E*qY&$Hj\\2bi&|g.\u00138g_\u0002")
public class HadoopRDD<K, V>
extends RDD<Tuple2<K, V>> {
    private final Broadcast<SerializableConfiguration> broadcastedConf;
    private final Option<Function1<JobConf, BoxedUnit>> initLocalJobConfFuncOpt;
    private final Class<? extends InputFormat<K, V>> inputFormatClass;
    private final int minPartitions;
    private final String jobConfCacheKey;
    private final String inputFormatCacheKey;
    private final Date org$apache$spark$rdd$HadoopRDD$$createTime;
    private final boolean shouldCloneJobConf;
    private final boolean org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles;
    private final boolean org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles;
    private final boolean ignoreEmptySplits;

    public static void addLocalConfiguration(String string, int n, int n2, int n3, JobConf jobConf) {
        HadoopRDD$.MODULE$.addLocalConfiguration(string, n, n2, n3, jobConf);
    }

    public static Object getCachedMetadata(String string) {
        return HadoopRDD$.MODULE$.getCachedMetadata(string);
    }

    public static Object CONFIGURATION_INSTANTIATION_LOCK() {
        return HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
    }

    public String jobConfCacheKey() {
        return this.jobConfCacheKey;
    }

    public String inputFormatCacheKey() {
        return this.inputFormatCacheKey;
    }

    public Date org$apache$spark$rdd$HadoopRDD$$createTime() {
        return this.org$apache$spark$rdd$HadoopRDD$$createTime;
    }

    private boolean shouldCloneJobConf() {
        return this.shouldCloneJobConf;
    }

    public boolean org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles() {
        return this.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles;
    }

    public boolean org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles() {
        return this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles;
    }

    private boolean ignoreEmptySplits() {
        return this.ignoreEmptySplits;
    }

    public JobConf getJobConf() {
        Configuration conf2 = this.broadcastedConf.value().value();
        if (this.shouldCloneJobConf()) {
            JobConf jobConf;
            Object object = HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
            synchronized (object) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cloning Hadoop Configuration");
                JobConf newJobConf = new JobConf(conf2);
                if (!(conf2 instanceof JobConf)) {
                    this.initLocalJobConfFuncOpt.foreach((Function1 & Serializable & scala.Serializable)f -> {
                        f.apply((Object)newJobConf);
                        return BoxedUnit.UNIT;
                    });
                }
                jobConf = newJobConf;
            }
            return jobConf;
        }
        Configuration configuration = conf2;
        if (configuration instanceof JobConf) {
            JobConf jobConf = (JobConf)configuration;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Re-using user-broadcasted JobConf");
            return jobConf;
        }
        return (JobConf)Option$.MODULE$.apply(HadoopRDD$.MODULE$.getCachedMetadata(this.jobConfCacheKey())).map((Function1 & Serializable & scala.Serializable)conf -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Re-using cached JobConf");
            return (JobConf)conf;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            JobConf jobConf;
            Object object = HadoopRDD$.MODULE$.CONFIGURATION_INSTANTIATION_LOCK();
            synchronized (object) {
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Creating new JobConf and caching it for later re-use");
                JobConf newJobConf = new JobConf(conf2);
                $this.initLocalJobConfFuncOpt.foreach((Function1 & Serializable & scala.Serializable)f -> {
                    f.apply((Object)newJobConf);
                    return BoxedUnit.UNIT;
                });
                HadoopRDD$.MODULE$.org$apache$spark$rdd$HadoopRDD$$putCachedMetadata(this.jobConfCacheKey(), newJobConf);
                jobConf = newJobConf;
            }
            return jobConf;
        });
    }

    public InputFormat<K, V> getInputFormat(JobConf conf) {
        InputFormat newInputFormat;
        block0: {
            newInputFormat = (InputFormat)ReflectionUtils.newInstance(this.inputFormatClass, (Configuration)conf);
            InputFormat inputFormat = newInputFormat;
            if (!(inputFormat instanceof Configurable)) break block0;
            InputFormat inputFormat2 = inputFormat;
            ((Configurable)inputFormat2).setConf((Configuration)conf);
        }
        return newInputFormat;
    }

    @Override
    public Partition[] getPartitions() {
        Partition[] partitionArray;
        JobConf jobConf = this.getJobConf();
        SparkHadoopUtil$.MODULE$.get().addCredentials(jobConf);
        try {
            InputSplit[] inputSplits;
            InputSplit[] allInputSplits = this.getInputFormat(jobConf).getSplits(jobConf, this.minPartitions);
            InputSplit[] inputSplitArray = inputSplits = this.ignoreEmptySplits() ? (InputSplit[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allInputSplits)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDD.$anonfun$getPartitions$1(x$1))) : allInputSplits;
            if (inputSplits.length == 1 && inputSplits[0] instanceof FileSplit) {
                FileSplit fileSplit = (FileSplit)inputSplits[0];
                Path path = fileSplit.getPath();
                if (fileSplit.getLength() > BoxesRunTime.unboxToLong((Object)this.conf().get(package$.MODULE$.IO_WARNING_LARGEFILETHRESHOLD()))) {
                    CompressionCodecFactory codecFactory = new CompressionCodecFactory((Configuration)jobConf);
                    if (Utils$.MODULE$.isFileSplittable(path, codecFactory)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(109).append("Loading one large file ").append(path.toString()).append(" with only one partition, ").append("we can increase partition numbers for improving performance.").toString());
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(127).append("Loading one large unsplittable file ").append(path.toString()).append(" with only one ").append("partition, because the file is compressed by unsplittable compression codec.").toString());
                    }
                }
            }
            Partition[] array = new Partition[new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSplits)).size()];
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputSplits)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                array$1[i] = new HadoopPartition(this.id(), i, inputSplits[i]);
            });
            partitionArray = array;
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidInputException) {
                InvalidInputException invalidInputException = (InvalidInputException)throwable2;
                if (this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append(jobConf.get("mapreduce.input.fileinputformat.inputdir")).append(" doesn't exist and no").append(" partitions returned from this path.").toString(), (Throwable)invalidInputException);
                    partitionArray = (Partition[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Partition.class));
                }
            }
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().startsWith("Not a file:")) {
                String path = ((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])iOException.getMessage().split(":"))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))[2];
                throw SparkCoreErrors$.MODULE$.pathNotSupportedError(path);
            }
            throw throwable;
        }
        return partitionArray;
    }

    @Override
    public InterruptibleIterator<Tuple2<K, V>> compute(Partition theSplit, TaskContext context) {
        NextIterator iter = new NextIterator<Tuple2<K, V>>(this, context, theSplit){
            private final HadoopPartition split;
            private final JobConf jobConf;
            private final InputMetrics inputMetrics;
            private final long existingBytesRead;
            private final Option<Function0<Object>> getBytesReadCallback;
            private RecordReader<K, V> reader;
            private final InputFormat<K, V> inputFormat;
            private final K key;
            private final V value;
            private final /* synthetic */ HadoopRDD $outer;

            private HadoopPartition split() {
                return this.split;
            }

            private JobConf jobConf() {
                return this.jobConf;
            }

            private InputMetrics inputMetrics() {
                return this.inputMetrics;
            }

            private long existingBytesRead() {
                return this.existingBytesRead;
            }

            private Option<Function0<Object>> getBytesReadCallback() {
                return this.getBytesReadCallback;
            }

            private void updateBytesRead() {
                this.getBytesReadCallback().foreach((Function1 & Serializable & scala.Serializable)getBytesRead -> {
                    $anon$1.$anonfun$updateBytesRead$1(this, getBytesRead);
                    return BoxedUnit.UNIT;
                });
            }

            private RecordReader<K, V> reader() {
                return this.reader;
            }

            private void reader_$eq(RecordReader<K, V> x$1) {
                this.reader = x$1;
            }

            private InputFormat<K, V> inputFormat() {
                return this.inputFormat;
            }

            private K key() {
                return this.key;
            }

            private V value() {
                return this.value;
            }

            public Tuple2<K, V> getNext() {
                try {
                    this.finished_$eq(!this.reader().next(this.key(), this.value()));
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Skipped missing file: ").append(this.split().inputSplit()).toString(), fileNotFoundException);
                            this.finished_$eq(true);
                        }
                    }
                    if (bl && !this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if (throwable2 instanceof IOException) {
                        IOException iOException = (IOException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Skipped the rest content in the corrupted file: ").append(this.split().inputSplit()).toString(), iOException);
                            this.finished_$eq(true);
                        }
                    }
                    throw throwable;
                }
                if (!this.finished()) {
                    this.inputMetrics().incRecordsRead(1L);
                }
                if (this.inputMetrics().recordsRead() % (long)SparkHadoopUtil$.MODULE$.UPDATE_INPUT_METRICS_INTERVAL_RECORDS() == 0L) {
                    this.updateBytesRead();
                }
                return new Tuple2(this.key(), this.value());
            }

            public void close() {
                if (this.reader() != null) {
                    InputFileBlockHolder$.MODULE$.unset();
                    try {
                        try {
                            this.reader().close();
                        }
                        catch (Exception e) {
                            if (!ShutdownHookManager$.MODULE$.inShutdown()) {
                                this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception in RecordReader.close()", e);
                            }
                        }
                    }
                    finally {
                        this.reader_$eq(null);
                    }
                    if (this.getBytesReadCallback().isDefined()) {
                        this.updateBytesRead();
                        return;
                    }
                    if (this.split().inputSplit().value() instanceof FileSplit || this.split().inputSplit().value() instanceof CombineFileSplit) {
                        try {
                            this.inputMetrics().incBytesRead(this.split().inputSplit().value().getLength());
                        }
                        catch (IOException e) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to get input size to set InputMetrics for task", e);
                        }
                        return;
                    }
                    return;
                }
            }

            public static final /* synthetic */ void $anonfun$updateBytesRead$1($anon$1 $this, Function0 getBytesRead) {
                $this.inputMetrics().setBytesRead($this.existingBytesRead() + getBytesRead.apply$mcJ$sp());
            }

            private final /* synthetic */ RecordReader liftedTree1$1() {
                RecordReader recordReader;
                try {
                    recordReader = this.inputFormat().getRecordReader(this.split().inputSplit().value(), this.jobConf(), Reporter.NULL);
                }
                catch (Throwable throwable) {
                    boolean bl = false;
                    FileNotFoundException fileNotFoundException = null;
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileNotFoundException) {
                        bl = true;
                        fileNotFoundException = (FileNotFoundException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Skipped missing file: ").append(this.split().inputSplit()).toString(), fileNotFoundException);
                            this.finished_$eq(true);
                            recordReader = null;
                        }
                    }
                    if (bl && !this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles()) {
                        throw fileNotFoundException;
                    }
                    if (throwable2 instanceof IOException) {
                        IOException iOException = (IOException)throwable2;
                        if (this.$outer.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Skipped the rest content in the corrupted file: ").append(this.split().inputSplit()).toString(), iOException);
                            this.finished_$eq(true);
                            recordReader = null;
                        }
                    }
                    throw throwable;
                }
                return recordReader;
            }

            public static final /* synthetic */ void $anonfun$new$4($anon$1 $this, TaskContext context) {
                $this.updateBytesRead();
                $this.closeIfNeeded();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.split = (HadoopPartition)theSplit$1;
                $outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Input split: ").append(this.split().inputSplit()).toString());
                this.jobConf = $outer.getJobConf();
                this.inputMetrics = context$1.taskMetrics().inputMetrics();
                this.existingBytesRead = this.inputMetrics().bytesRead();
                InputSplit inputSplit = this.split().inputSplit().value();
                if (inputSplit instanceof FileSplit) {
                    FileSplit fileSplit = (FileSplit)inputSplit;
                    InputFileBlockHolder$.MODULE$.set(fileSplit.getPath().toString(), fileSplit.getStart(), fileSplit.getLength());
                } else {
                    InputFileBlockHolder$.MODULE$.unset();
                }
                InputSplit inputSplit2 = this.split().inputSplit().value();
                this.getBytesReadCallback = (inputSplit2 instanceof FileSplit ? true : inputSplit2 instanceof CombineFileSplit) ? new Some(SparkHadoopUtil$.MODULE$.get().getFSBytesReadOnThreadCallback()) : None$.MODULE$;
                this.reader = null;
                this.inputFormat = $outer.getInputFormat(this.jobConf());
                HadoopRDD$.MODULE$.addLocalConfiguration(new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format($outer.org$apache$spark$rdd$HadoopRDD$$createTime()), context$1.stageId(), theSplit$1.index(), context$1.attemptNumber(), this.jobConf());
                this.reader_$eq(this.liftedTree1$1());
                context$1.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
                    $anon$1.$anonfun$new$4(this, context);
                    return BoxedUnit.UNIT;
                });
                this.key = this.reader() == null ? null : this.reader().createKey();
                this.value = this.reader() == null ? null : this.reader().createValue();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$updateBytesRead$1$adapted(org.apache.spark.rdd.HadoopRDD$$anon$1 scala.Function0 ), $anonfun$getNext$1(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$getNext$2(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$close$1(), $anonfun$close$2(), $anonfun$new$2(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$3(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$1(org.apache.spark.rdd.HadoopRDD$$anon$1 ), $anonfun$new$4$adapted(org.apache.spark.rdd.HadoopRDD$$anon$1 org.apache.spark.TaskContext )}, serializedLambda);
            }
        };
        return new InterruptibleIterator<Tuple2<K, V>>(context, iter);
    }

    @DeveloperApi
    public <U> RDD<U> mapPartitionsWithInputSplit(Function2<InputSplit, Iterator<Tuple2<K, V>>, Iterator<U>> f, boolean preservesPartitioning, ClassTag<U> evidence$1) {
        return new HadoopMapPartitionsWithSplitRDD<U, Tuple2<K, V>>(this, f, preservesPartitioning, evidence$1, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <U> boolean mapPartitionsWithInputSplit$default$2() {
        return false;
    }

    @Override
    public Seq<String> getPreferredLocations(Partition split) {
        Option<Seq<String>> option;
        InputSplit hsplit = ((HadoopPartition)split).inputSplit().value();
        InputSplit inputSplit = hsplit;
        if (inputSplit instanceof InputSplitWithLocationInfo) {
            InputSplitWithLocationInfo inputSplitWithLocationInfo = (InputSplitWithLocationInfo)inputSplit;
            option = HadoopRDD$.MODULE$.convertSplitLocationInfo(inputSplitWithLocationInfo.getLocationInfo());
        } else {
            option = None$.MODULE$;
        }
        Option<Seq<String>> locs = option;
        return (Seq)locs.getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])hsplit.getLocations())).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HadoopRDD.$anonfun$getPreferredLocations$2(x$3)))));
    }

    @Override
    public void checkpoint() {
    }

    public HadoopRDD<K, V> persist(StorageLevel storageLevel) {
        block0: {
            if (!storageLevel.deserialized()) break block0;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Caching HadoopRDDs as deserialized objects usually leads to undesired behavior because Hadoop's RecordReader reuses the same Writable object for all records. Use a map transformation to make copies of the records.");
        }
        return (HadoopRDD)super.persist(storageLevel);
    }

    public Configuration getConf() {
        return this.getJobConf();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitions$1(InputSplit x$1) {
        return x$1.getLength() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getPreferredLocations$2(String x$3) {
        String string = x$3;
        String string2 = "localhost";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public HadoopRDD(SparkContext sc, Broadcast<SerializableConfiguration> broadcastedConf, Option<Function1<JobConf, BoxedUnit>> initLocalJobConfFuncOpt, Class<? extends InputFormat<K, V>> inputFormatClass, Class<K> keyClass, Class<V> valueClass, int minPartitions) {
        BoxedUnit boxedUnit;
        this.broadcastedConf = broadcastedConf;
        this.initLocalJobConfFuncOpt = initLocalJobConfFuncOpt;
        this.inputFormatClass = inputFormatClass;
        this.minPartitions = minPartitions;
        super(sc, (Seq<Dependency<?>>)Nil$.MODULE$, ClassTag$.MODULE$.apply(Tuple2.class));
        if (initLocalJobConfFuncOpt.isDefined()) {
            SparkContext qual$1 = this.sparkContext();
            Function1 x$1 = (Function1)initLocalJobConfFuncOpt.get();
            boolean x$2 = qual$1.clean$default$2();
            boxedUnit = qual$1.clean(x$1, x$2);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.jobConfCacheKey = new StringOps(Predef$.MODULE$.augmentString("rdd_%d_job_conf")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
        this.inputFormatCacheKey = new StringOps(Predef$.MODULE$.augmentString("rdd_%d_input_format")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.id())}));
        this.org$apache$spark$rdd$HadoopRDD$$createTime = new Date();
        this.shouldCloneJobConf = this.sparkContext().conf().getBoolean("spark.hadoop.cloneConf", false);
        this.org$apache$spark$rdd$HadoopRDD$$ignoreCorruptFiles = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.IGNORE_CORRUPT_FILES()));
        this.org$apache$spark$rdd$HadoopRDD$$ignoreMissingFiles = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.IGNORE_MISSING_FILES()));
        this.ignoreEmptySplits = BoxesRunTime.unboxToBoolean((Object)this.sparkContext().conf().get(package$.MODULE$.HADOOP_RDD_IGNORE_EMPTY_SPLITS()));
    }

    public HadoopRDD(SparkContext sc, JobConf conf, Class<? extends InputFormat<K, V>> inputFormatClass, Class<K> keyClass, Class<V> valueClass, int minPartitions) {
        this(sc, sc.broadcast(new SerializableConfiguration((Configuration)conf), ClassTag$.MODULE$.apply(SerializableConfiguration.class)), (Option<Function1<JobConf, BoxedUnit>>)None$.MODULE$, inputFormatClass, keyClass, valueClass, minPartitions);
    }

    public static class HadoopMapPartitionsWithSplitRDD<U, T>
    extends RDD<U> {
        private final Function2<InputSplit, Iterator<T>, Iterator<U>> f;
        private final ClassTag<T> evidence$3;
        private final Option<Partitioner> partitioner;

        @Override
        public Option<Partitioner> partitioner() {
            return this.partitioner;
        }

        @Override
        public Partition[] getPartitions() {
            return this.firstParent(this.evidence$3).partitions();
        }

        @Override
        public Iterator<U> compute(Partition split, TaskContext context) {
            HadoopPartition partition = (HadoopPartition)split;
            InputSplit inputSplit = partition.inputSplit().value();
            return (Iterator)this.f.apply((Object)inputSplit, this.firstParent(this.evidence$3).iterator(split, context));
        }

        public HadoopMapPartitionsWithSplitRDD(RDD<T> prev, Function2<InputSplit, Iterator<T>, Iterator<U>> f, boolean preservesPartitioning, ClassTag<U> evidence$2, ClassTag<T> evidence$3) {
            this.f = f;
            this.evidence$3 = evidence$3;
            super(prev, evidence$2);
            this.partitioner = preservesPartitioning ? this.firstParent(evidence$3).partitioner() : None$.MODULE$;
        }
    }
}

