/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.functionobjects;

import org.apache.sysds.runtime.functionobjects.IndexFunction;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.meta.DataCharacteristics;

public class OffsetColumnIndex
extends IndexFunction {
    private static final long serialVersionUID = 1523769994005450946L;
    private int offset;
    private int numRowsInOutput;
    private int numColumnsInOutput;

    private OffsetColumnIndex(int offset) {
        this.offset = offset;
    }

    public static OffsetColumnIndex getOffsetColumnIndexFnObject(int offset) {
        return new OffsetColumnIndex(offset);
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public void execute(MatrixIndexes in, MatrixIndexes out) {
        out.setIndexes(in.getRowIndex(), in.getColumnIndex() + (long)this.offset);
    }

    @Override
    public void execute(MatrixValue.CellIndex in, MatrixValue.CellIndex out) {
        out.row = in.row;
        out.column = this.offset + in.column;
    }

    @Override
    public boolean computeDimension(int row, int col, MatrixValue.CellIndex retDim) {
        retDim.set(this.numRowsInOutput, this.numColumnsInOutput);
        return false;
    }

    @Override
    public boolean computeDimension(DataCharacteristics in, DataCharacteristics out) {
        out.set(this.numRowsInOutput, (long)this.numColumnsInOutput, in.getBlocksize());
        return false;
    }
}

