/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.compress;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.compress.estim.ComEstFactory;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.ACompressedArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.DDCArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.frame.data.compress.FrameCompressionSettings;
import org.apache.sysds.runtime.frame.data.compress.FrameCompressionSettingsBuilder;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.utils.stats.Timing;

public class CompressedFrameBlockFactory {
    private static final Log LOG = LogFactory.getLog((String)CompressedFrameBlockFactory.class.getName());
    private static final int DEFAULT_MIN_CELLS = 10000;
    private static final int DEFAULT_MAX_CELLS = 1000000;
    private final FrameBlock in;
    private final FrameCompressionSettings cs;
    private final ArrayCompressionStatistics[] stats;
    private final Array<?>[] compressedColumns;
    private final int nSamples;

    private CompressedFrameBlockFactory(FrameBlock fb, FrameCompressionSettings cs) {
        this.in = fb;
        this.cs = cs;
        this.stats = new ArrayCompressionStatistics[this.in.getNumColumns()];
        this.compressedColumns = new Array[this.in.getNumColumns()];
        int minSampleRows = Math.max((int)((double)this.in.getNumRows() * cs.sampleRatio), 10000);
        int exponentialDecreaseRows = ComEstFactory.getSampleSize(0.65, this.in.getNumRows(), this.in.getNumColumns(), 1.0, 10000, 1000000);
        this.nSamples = Math.min(minSampleRows, exponentialDecreaseRows);
    }

    public static FrameBlock compress(FrameBlock fb, int k, WTreeRoot root) {
        FrameCompressionSettings cs = new FrameCompressionSettingsBuilder().threads(k).wTreeRoot(root).create();
        return CompressedFrameBlockFactory.compress(fb, cs);
    }

    public static FrameBlock compress(FrameBlock fb, FrameCompressionSettings cs) {
        return new CompressedFrameBlockFactory(fb, cs).compressFrame();
    }

    private FrameBlock compressFrame() {
        Timing time = LOG.isDebugEnabled() ? new Timing(true) : null;
        this.encodeColumns();
        FrameBlock ret = new FrameBlock(this.compressedColumns, this.in.getColumnNames(false));
        this.logStatistics();
        this.logRet(ret);
        if (time != null) {
            LOG.debug((Object)("Frame Compression time : " + time.stop()));
        }
        return ret;
    }

    private void encodeColumns() {
        if (this.cs.k > 4) {
            this.encodeParallel();
        } else {
            this.encodeSingleThread();
        }
    }

    private void encodeSingleThread() {
        for (int i = 0; i < this.compressedColumns.length; ++i) {
            this.compressCol(i);
        }
    }

    private void encodeParallel() {
        ExecutorService pool = CommonThreadPool.get(this.cs.k);
        try {
            ArrayList<Future<Array>> tasks = new ArrayList<Future<Array>>();
            int j = 0;
            while (j < this.compressedColumns.length) {
                int n = j++;
                Future<Array> tmp = pool.submit(() -> this.collectStatsAndAllocateCorrectedType(i));
                Future<Array> tmp2 = pool.submit(() -> this.changeTypeFuture(i, tmp, pool, this.cs.k));
                tasks.add(pool.submit(() -> this.compressColFinally(i, tmp2)));
            }
            for (Future future : tasks) {
                future.get();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
    }

    private void compressCol(int i) {
        this.compressCol(i, this.getStatistics(i));
    }

    private ArrayCompressionStatistics getStatistics(int i) {
        this.stats[i] = this.in.getColumn(i).statistics(this.nSamples);
        return this.stats[i];
    }

    private Array<?> collectStatsAndAllocateCorrectedType(int i) {
        this.stats[i] = this.getStatistics(i);
        return this.allocateCorrectedType(i);
    }

    private Array<?> compressColFinally(int i, Future<Array<?>> f) throws Exception {
        return this.compressColFinally(i, f.get(), this.stats[i]);
    }

    private Array<?> allocateCorrectedType(int i) {
        ArrayCompressionStatistics s = this.stats[i];
        Array<?> a = this.in.getColumn(i);
        if (s.valueType != a.getValueType()) {
            return ArrayFactory.allocate(s.valueType, a.size(), s.containsNull);
        }
        return a;
    }

    private boolean tryChange(Array<?> a, Array<?> tmp, int start, int end) {
        try {
            a.changeTypeWithNulls(tmp, start, end);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Array<?> changeTypeFuture(int i, Future<Array<?>> f, ExecutorService pool, int k) throws Exception {
        Array<?> tmp = f.get();
        Array<?> a = this.in.getColumn(i);
        ArrayCompressionStatistics s = this.stats[i];
        if (s.valueType != a.getValueType()) {
            int nRow = this.in.getNumRows();
            int block = Math.max(nRow / k / 64 * 64, 1024);
            ArrayList<Future<Boolean>> t = new ArrayList<Future<Boolean>>();
            for (int r = 0; r < nRow; r += block) {
                int n = r;
                int end = Math.min(r + block, nRow);
                t.add(pool.submit(() -> this.tryChange(a, tmp, start, end)));
            }
            for (Future future : t) {
                if (((Boolean)future.get()).booleanValue()) continue;
                Pair<Types.ValueType, Boolean> sc = a.analyzeValueType();
                LOG.warn((Object)("Failed to change type of column: " + i + " sample said value type: " + tmp.getValueType() + " Full analysis says: " + (Object)((Object)sc.getKey())));
                Array<?> tmp2 = ArrayFactory.allocate(sc.getKey(), nRow, sc.getValue());
                a.changeType(tmp2);
                return tmp2;
            }
        }
        return tmp;
    }

    private void compressCol(int i, ArrayCompressionStatistics s) {
        Array<?> b = this.in.getColumn(i);
        Array<?> a = s.valueType != b.getValueType() ? b.changeType(s.valueType, s.containsNull) : b;
        this.compressColFinally(i, a, s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Array<?> compressColFinally(int i, Array<?> a, ArrayCompressionStatistics s) {
        Timing time;
        Timing timing = time = LOG.isDebugEnabled() ? new Timing(true) : null;
        if (s.bestType != null && s.shouldCompress) {
            if (s.bestType != ArrayFactory.FrameArrayType.DDC) throw new RuntimeException("Unsupported frame compression encoding : " + s.bestType);
            this.compressedColumns[i] = DDCArray.compressToDDC(a, s.sampledAllRows ? s.nUnique : Integer.MAX_VALUE);
        } else {
            this.compressedColumns[i] = a;
        }
        if (time == null) return a;
        LOG.debug((Object)("Timing Compression : " + i + " " + a.getValueType() + " " + time.stop()));
        return a;
    }

    private void logStatistics() {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(1000);
            sb.append("\n");
            for (int i = 0; i < this.compressedColumns.length; ++i) {
                if (this.in.getColumn(i) instanceof ACompressedArray) {
                    sb.append(String.format("Col: %3d, %s\n", i, "Column is already compressed"));
                    continue;
                }
                sb.append(String.format("Col: %3d, %s\n", i, this.stats[i]));
            }
            LOG.debug((Object)sb);
        }
    }

    private void logRet(FrameBlock ret) {
        if (LOG.isDebugEnabled()) {
            long before = this.in.getInMemorySize();
            long after = ret.getInMemorySize();
            LOG.debug((Object)String.format("nRows              %15d", this.in.getNumRows()));
            LOG.debug((Object)String.format("SampleSize         %15d", this.nSamples));
            LOG.debug((Object)String.format("Uncompressed Size: %15d", before));
            LOG.debug((Object)String.format("compressed Size:   %15d", after));
            LOG.debug((Object)String.format("ratio:             %15.3f", (double)before / (double)after));
        }
    }
}

