/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.dataflow.data.common.TypeResolverUtil;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;

public class SwitchCaseComputer
implements IResultTypeComputer {
    public static final IResultTypeComputer INSTANCE = new SwitchCaseComputer();

    private SwitchCaseComputer() {
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expression;
        String funcName = fce.getFunctionIdentifier().getName();
        int argSize = fce.getArguments().size();
        if (argSize < 3) {
            throw new CompilationException(1008, fce.getSourceLocation(), new Serializable[]{funcName, Integer.valueOf(argSize)});
        }
        ArrayList<IAType> types = new ArrayList<IAType>();
        for (int argIndex = 2; argIndex < argSize; argIndex += argIndex + 2 == argSize ? 1 : 2) {
            IAType type = (IAType)env.getType((ILogicalExpression)((Mutable)fce.getArguments().get(argIndex)).getValue());
            types.add(type);
        }
        if (this.addDefaultNull(argSize)) {
            types.add(BuiltinType.ANULL);
        }
        return TypeResolverUtil.resolve(types);
    }

    private boolean addDefaultNull(int argSize) {
        return argSize % 2 != 0;
    }
}

