/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.data;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.INumeric;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import org.apache.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;

public class PointablePrimitiveValueProviderFactory
implements IPrimitiveValueProviderFactory {
    private static final long serialVersionUID = 1L;
    private final IPointableFactory pf;

    public PointablePrimitiveValueProviderFactory(IPointableFactory pf) {
        this.pf = pf;
    }

    @Override
    public IPrimitiveValueProvider createPrimitiveValueProvider() {
        final IPointable p = this.pf.createPointable();
        ITypeTraits traits = this.pf.getTypeTraits();
        assert (traits.isFixedLength());
        final int length = traits.getFixedLength();
        return new IPrimitiveValueProvider(){

            @Override
            public double getValue(byte[] bytes, int offset) {
                p.set(bytes, offset, length);
                return ((INumeric)p).doubleValue();
            }
        };
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.set("pf", this.pf.toJson(registry));
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) throws HyracksDataException {
        IPointableFactory pf = (IPointableFactory)registry.deserialize(json.get("pf"));
        return new PointablePrimitiveValueProviderFactory(pf);
    }
}

