/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.dataflow;

import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.FileSplit;
import org.apache.hyracks.dataflow.std.file.IFileSplitProvider;
import org.apache.hyracks.storage.am.common.api.IIndexDataflowHelper;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.common.dataflow.IndexDataflowHelper;
import org.apache.hyracks.storage.common.IStorageManager;

public class IndexDataflowHelperFactory
implements IIndexDataflowHelperFactory {
    private static final long serialVersionUID = 1L;
    private final IStorageManager storageMgr;
    private final IFileSplitProvider fileSplitProvider;

    public IndexDataflowHelperFactory(IStorageManager storageMgr, IFileSplitProvider fileSplitProvider) {
        this.storageMgr = storageMgr;
        this.fileSplitProvider = fileSplitProvider;
    }

    @Override
    public IIndexDataflowHelper create(INCServiceContext ctx, int partition) throws HyracksDataException {
        FileSplit fileSplit = this.fileSplitProvider.getFileSplits()[partition];
        FileReference resourceRef = fileSplit.getFileReference(ctx.getIoManager());
        return new IndexDataflowHelper(ctx, this.storageMgr, resourceRef);
    }
}

