/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.impls.NoOpIndexAccessParameters;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponentFilter;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeMemoryComponent;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeWithAntimatterDiskComponent;
import org.apache.hyracks.storage.am.rtree.impls.RTree;
import org.apache.hyracks.storage.am.rtree.impls.RTreeSearchCursor;
import org.apache.hyracks.storage.am.rtree.impls.SearchPredicate;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMRTreeWithAntiMatterTuplesSearchCursor
extends LSMIndexSearchCursor {
    private ITreeIndexAccessor[] mutableRTreeAccessors;
    private ITreeIndexAccessor[] btreeAccessors;
    private RTreeSearchCursor[] mutableRTreeCursors;
    private ITreeIndexCursor[] btreeCursors;
    private RangePredicate btreeRangePredicate;
    private boolean foundNext;
    private ITupleReference frameTuple;
    private int[] comparatorFields;
    private MultiComparator btreeCmp;
    private int currentCursor = 0;
    private SearchPredicate rtreeSearchPredicate;
    private int numMemoryComponents;
    private boolean open;
    protected ISearchOperationCallback searchCallback;
    private boolean resultOfsearchCallBackProceed = false;

    public LSMRTreeWithAntiMatterTuplesSearchCursor(ILSMIndexOperationContext opCtx) {
        this(opCtx, false, NoOpIndexCursorStats.INSTANCE);
    }

    public LSMRTreeWithAntiMatterTuplesSearchCursor(ILSMIndexOperationContext opCtx, boolean returnDeletedTuples, IIndexCursorStats stats) {
        super(opCtx, returnDeletedTuples, stats);
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMRTreeCursorInitialState lsmInitialState = (LSMRTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getHilbertCmp();
        this.btreeCmp = lsmInitialState.getBTreeCmp();
        this.lsmHarness = lsmInitialState.getLSMHarness();
        this.comparatorFields = lsmInitialState.getComparatorFields();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.rtreeSearchPredicate = (SearchPredicate)searchPred;
        this.searchCallback = lsmInitialState.getSearchOperationCallback();
        this.numMemoryComponents = 0;
        int numImmutableComponents = 0;
        for (ILSMComponent component : this.operationalComponents) {
            if (component.getType() == ILSMComponent.LSMComponentType.MEMORY) {
                ++this.numMemoryComponents;
                continue;
            }
            ++numImmutableComponents;
        }
        if (this.numMemoryComponents > 0) {
            this.btreeRangePredicate = new RangePredicate(null, null, true, true, this.btreeCmp, this.btreeCmp);
        }
        this.mutableRTreeCursors = new RTreeSearchCursor[this.numMemoryComponents];
        this.mutableRTreeAccessors = new ITreeIndexAccessor[this.numMemoryComponents];
        this.btreeCursors = new BTreeRangeSearchCursor[this.numMemoryComponents];
        this.btreeAccessors = new ITreeIndexAccessor[this.numMemoryComponents];
        for (int i = 0; i < this.numMemoryComponents; ++i) {
            ILSMComponent component;
            component = (ILSMComponent)this.operationalComponents.get(i);
            RTree rtree = ((LSMRTreeMemoryComponent)component).getIndex();
            BTree btree = ((LSMRTreeMemoryComponent)component).getBuddyIndex();
            this.btreeAccessors[i] = btree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            this.mutableRTreeAccessors[i] = rtree.createAccessor((IIndexAccessParameters)NoOpIndexAccessParameters.INSTANCE);
            this.btreeCursors[i] = (ITreeIndexCursor)this.btreeAccessors[i].createSearchCursor(false);
            this.mutableRTreeCursors[i] = (RTreeSearchCursor)this.mutableRTreeAccessors[i].createSearchCursor(false);
        }
        this.rangeCursors = new RTreeSearchCursor[numImmutableComponents];
        ITreeIndexAccessor[] immutableRTreeAccessors = new ITreeIndexAccessor[numImmutableComponents];
        int j = 0;
        try {
            for (int i = this.numMemoryComponents; i < this.operationalComponents.size(); ++i) {
                ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
                RTree rtree = ((LSMRTreeWithAntimatterDiskComponent)component).getIndex();
                immutableRTreeAccessors[j] = rtree.createAccessor(this.iap);
                this.rangeCursors[j] = immutableRTreeAccessors[j].createSearchCursor(false);
                immutableRTreeAccessors[j].search(this.rangeCursors[j], searchPred);
                ++j;
            }
            this.searchNextCursor();
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rangeCursors, (Throwable)th);
            IndexCursorUtils.close((IIndexCursor[])this.mutableRTreeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
        this.open = true;
    }

    private void searchNextCursor() throws HyracksDataException {
        if (this.currentCursor < this.numMemoryComponents) {
            this.mutableRTreeCursors[this.currentCursor].close();
            this.mutableRTreeAccessors[this.currentCursor].search((IIndexCursor)this.mutableRTreeCursors[this.currentCursor], (ISearchPredicate)this.rtreeSearchPredicate);
        }
    }

    public boolean doHasNext() throws HyracksDataException {
        if (this.numMemoryComponents > 0) {
            if (this.foundNext) {
                return true;
            }
            while (this.currentCursor < this.numMemoryComponents) {
                while (this.mutableRTreeCursors[this.currentCursor].hasNext()) {
                    this.mutableRTreeCursors[this.currentCursor].next();
                    ITupleReference currentTuple = this.mutableRTreeCursors[this.currentCursor].getTuple();
                    this.resultOfsearchCallBackProceed = this.searchCallback.proceed(currentTuple);
                    if (!this.searchMemBTrees(currentTuple, this.currentCursor)) continue;
                    this.foundNext = true;
                    this.frameTuple = currentTuple;
                    return true;
                }
                this.mutableRTreeCursors[this.currentCursor].close();
                ++this.currentCursor;
                this.searchNextCursor();
            }
            while (super.doHasNext()) {
                super.doNext();
                ITupleReference diskRTreeTuple = super.doGetTuple();
                this.resultOfsearchCallBackProceed = true;
                if (!this.searchMemBTrees(diskRTreeTuple, this.numMemoryComponents)) continue;
                this.foundNext = true;
                this.frameTuple = diskRTreeTuple;
                return true;
            }
        } else if (super.doHasNext()) {
            super.doNext();
            ITupleReference diskRTreeTuple = super.doGetTuple();
            this.resultOfsearchCallBackProceed = this.searchCallback.proceed(diskRTreeTuple);
            this.foundNext = true;
            this.frameTuple = diskRTreeTuple;
            return true;
        }
        return false;
    }

    public ITupleReference getFilterMinTuple() {
        ILSMComponentFilter filter = ((ILSMComponent)this.operationalComponents.get(this.currentCursor < this.numMemoryComponents ? this.currentCursor : this.outputElement.getCursorIndex() + this.currentCursor)).getLSMComponentFilter();
        return filter == null ? null : filter.getMinTuple();
    }

    public ITupleReference getFilterMaxTuple() {
        ILSMComponentFilter filter = ((ILSMComponent)this.operationalComponents.get(this.currentCursor < this.numMemoryComponents ? this.currentCursor : this.outputElement.getCursorIndex() + this.currentCursor)).getLSMComponentFilter();
        return filter == null ? null : filter.getMaxTuple();
    }

    public void doNext() throws HyracksDataException {
        this.foundNext = false;
    }

    public ITupleReference doGetTuple() {
        return this.frameTuple;
    }

    public void doClose() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        this.currentCursor = 0;
        this.foundNext = false;
        if (this.numMemoryComponents > 0) {
            for (int i = 0; i < this.numMemoryComponents; ++i) {
                this.mutableRTreeCursors[i].close();
                this.btreeCursors[i].close();
            }
        }
        super.doClose();
    }

    public void doDestroy() throws HyracksDataException {
        if (!this.open) {
            return;
        }
        if (this.numMemoryComponents > 0) {
            for (int i = 0; i < this.numMemoryComponents; ++i) {
                this.mutableRTreeCursors[i].destroy();
                this.btreeCursors[i].destroy();
            }
        }
        this.currentCursor = 0;
        this.open = false;
        super.doDestroy();
    }

    protected int compare(MultiComparator cmp, ITupleReference tupleA, ITupleReference tupleB) throws HyracksDataException {
        return cmp.selectiveFieldCompare(tupleA, tupleB, this.comparatorFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean searchMemBTrees(ITupleReference tuple, int lastBTreeToSearch) throws HyracksDataException {
        for (int i = 0; i < lastBTreeToSearch; ++i) {
            this.btreeCursors[i].close();
            this.btreeRangePredicate.setHighKey(tuple, true);
            this.btreeRangePredicate.setLowKey(tuple, true);
            this.btreeAccessors[i].search((IIndexCursor)this.btreeCursors[i], (ISearchPredicate)this.btreeRangePredicate);
            try {
                if (!this.btreeCursors[i].hasNext()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                this.btreeCursors[i].close();
            }
        }
        return true;
    }

    protected void setPriorityQueueComparator() {
        if (this.pqCmp == null || this.cmp != this.pqCmp.getMultiComparator()) {
            this.pqCmp = new PriorityQueueHilbertComparator(this.cmp, this.comparatorFields);
        }
    }

    public boolean getSearchOperationCallbackProceedResult() {
        return this.resultOfsearchCallBackProceed;
    }

    public class PriorityQueueHilbertComparator
    extends LSMIndexSearchCursor.PriorityQueueComparator {
        private final int[] comparatorFields;

        public PriorityQueueHilbertComparator(MultiComparator cmp, int[] comparatorFields) {
            super(cmp);
            this.comparatorFields = comparatorFields;
        }

        public int compare(LSMIndexSearchCursor.PriorityQueueElement elementA, LSMIndexSearchCursor.PriorityQueueElement elementB) {
            try {
                int result = this.cmp.selectiveFieldCompare(elementA.getTuple(), elementB.getTuple(), this.comparatorFields);
                if (result != 0) {
                    return result;
                }
            }
            catch (HyracksDataException e) {
                throw new IllegalArgumentException(e);
            }
            if (elementA.getCursorIndex() > elementB.getCursorIndex()) {
                return 1;
            }
            return -1;
        }
    }
}

