/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.aggregates.serializable.std.AbstractSerializableAggregateFunction;
import org.apache.asterix.runtime.aggregates.serializable.std.BufferSerDeUtil;
import org.apache.asterix.runtime.aggregates.utils.SingleVarFunctionsUtil;
import org.apache.asterix.runtime.evaluators.common.AccessibleByteArrayEval;
import org.apache.asterix.runtime.evaluators.common.ClosedRecordConstructorEvalFactory;
import org.apache.asterix.runtime.exceptions.IncompatibleTypeException;
import org.apache.asterix.runtime.exceptions.UnsupportedItemTypeException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ByteArrayAccessibleOutputStream;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSerializableSingleVariableStatisticsAggregateFunction
extends AbstractSerializableAggregateFunction {
    private static final int M1_FIELD_ID = 0;
    private static final int M2_FIELD_ID = 1;
    private static final int M3_FIELD_ID = 2;
    private static final int M4_FIELD_ID = 3;
    private static final int COUNT_FIELD_ID = 4;
    private static final int M1_OFFSET = 0;
    private static final int M2_OFFSET = 8;
    private static final int M3_OFFSET = 16;
    private static final int M4_OFFSET = 24;
    private static final int COUNT_OFFSET = 32;
    protected static final int AGG_TYPE_OFFSET = 40;
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private SingleVarFunctionsUtil moments = new SingleVarFunctionsUtil();
    private IPointable resultBytes = new VoidPointable();
    private ByteArrayAccessibleOutputStream m1Bytes = new ByteArrayAccessibleOutputStream();
    private DataOutput m1BytesOutput = new DataOutputStream((OutputStream)this.m1Bytes);
    private ByteArrayAccessibleOutputStream m2Bytes = new ByteArrayAccessibleOutputStream();
    private DataOutput m2BytesOutput = new DataOutputStream((OutputStream)this.m2Bytes);
    private ByteArrayAccessibleOutputStream m3Bytes = new ByteArrayAccessibleOutputStream();
    private DataOutput m3BytesOutput = new DataOutputStream((OutputStream)this.m3Bytes);
    private ByteArrayAccessibleOutputStream m4Bytes = new ByteArrayAccessibleOutputStream();
    private DataOutput m4BytesOutput = new DataOutputStream((OutputStream)this.m4Bytes);
    private ByteArrayAccessibleOutputStream countBytes = new ByteArrayAccessibleOutputStream();
    private DataOutput countBytesOutput = new DataOutputStream((OutputStream)this.countBytes);
    private IScalarEvaluator evalM1 = new AccessibleByteArrayEval(this.m1Bytes);
    private IScalarEvaluator evalM2 = new AccessibleByteArrayEval(this.m2Bytes);
    private IScalarEvaluator evalM3 = new AccessibleByteArrayEval(this.m3Bytes);
    private IScalarEvaluator evalM4 = new AccessibleByteArrayEval(this.m4Bytes);
    private IScalarEvaluator evalCount = new AccessibleByteArrayEval(this.countBytes);
    private ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval recordEval;
    private ISerializerDeserializer<ADouble> doubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);
    private ISerializerDeserializer<AInt64> longSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);

    public AbstractSerializableSingleVariableStatisticsAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init(DataOutput state) throws HyracksDataException {
        try {
            state.writeDouble(0.0);
            state.writeDouble(0.0);
            state.writeDouble(0.0);
            state.writeDouble(0.0);
            state.writeLong(0L);
            state.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            this.moments.set(0.0, 0.0, 0.0, 0.0, 0L, this.getM3Flag(), this.getM4Flag());
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public abstract void step(IFrameTupleReference var1, byte[] var2, int var3, int var4) throws HyracksDataException;

    public abstract void finish(byte[] var1, int var2, int var3, DataOutput var4) throws HyracksDataException;

    public abstract void finishPartial(byte[] var1, int var2, int var3, DataOutput var4) throws HyracksDataException;

    protected abstract void processNull(byte[] var1, int var2);

    protected abstract FunctionIdentifier getFunctionIdentifier();

    protected abstract boolean getM3Flag();

    protected abstract boolean getM4Flag();

    protected void processDataValues(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] bytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        double m1 = BufferSerDeUtil.getDouble(state, start + 0);
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        double m3 = BufferSerDeUtil.getDouble(state, start + 16);
        double m4 = BufferSerDeUtil.getDouble(state, start + 24);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        this.moments.set(m1, m2, m3, m4, count, this.getM3Flag(), this.getM4Flag());
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull(state, start);
            return;
        }
        if (aggType == ATypeTag.SYSTEM_NULL) {
            aggType = typeTag;
        } else {
            if (typeTag != ATypeTag.SYSTEM_NULL && !ATypeHierarchy.isCompatible((ATypeTag)typeTag, (ATypeTag)aggType)) {
                if (typeTag.ordinal() > aggType.ordinal()) {
                    throw new IncompatibleTypeException(this.sourceLoc, this.getFunctionIdentifier(), bytes[offset], aggType.serialize());
                }
                throw new IncompatibleTypeException(this.sourceLoc, this.getFunctionIdentifier(), aggType.serialize(), bytes[offset]);
            }
            if (ATypeHierarchy.canPromote((ATypeTag)aggType, (ATypeTag)typeTag)) {
                aggType = typeTag;
            }
        }
        switch (typeTag) {
            case TINYINT: {
                double val = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            case SMALLINT: {
                double val = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            case INTEGER: {
                double val = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            case BIGINT: {
                double val = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            case FLOAT: {
                double val = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            case DOUBLE: {
                double val = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                this.moments.push(val);
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(this.sourceLoc, this.getFunctionIdentifier(), bytes[offset]);
            }
        }
        BufferSerDeUtil.writeDouble(this.moments.getM1(), state, start + 0);
        BufferSerDeUtil.writeDouble(this.moments.getM2(), state, start + 8);
        BufferSerDeUtil.writeDouble(this.moments.getM3(), state, start + 16);
        BufferSerDeUtil.writeDouble(this.moments.getM4(), state, start + 24);
        BufferSerDeUtil.writeLong(this.moments.getCount(), state, start + 32);
        state[start + 40] = aggType.serialize();
    }

    protected void finishPartialResults(byte[] state, int start, int len, DataOutput result) throws HyracksDataException {
        double m1 = BufferSerDeUtil.getDouble(state, start + 0);
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        double m3 = BufferSerDeUtil.getDouble(state, start + 16);
        double m4 = BufferSerDeUtil.getDouble(state, start + 24);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        if (this.recordEval == null) {
            ARecordType recType = new ARecordType(null, new String[]{"m1", "m2", "m3", "m4", "count"}, new IAType[]{BuiltinType.ADOUBLE, BuiltinType.ADOUBLE, BuiltinType.ADOUBLE, BuiltinType.ADOUBLE, BuiltinType.AINT64}, false);
            this.recordEval = new ClosedRecordConstructorEvalFactory.ClosedRecordConstructorEval(recType, new IScalarEvaluator[]{this.evalM1, this.evalM2, this.evalM3, this.evalM4, this.evalCount});
        }
        try {
            if (aggType == ATypeTag.SYSTEM_NULL) {
                result.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            } else if (aggType == ATypeTag.NULL) {
                result.writeByte(ATypeTag.SERIALIZED_NULL_TYPE_TAG);
            } else {
                this.m1Bytes.reset();
                this.aDouble.setValue(m1);
                this.doubleSerde.serialize((Object)this.aDouble, this.m1BytesOutput);
                this.m2Bytes.reset();
                this.aDouble.setValue(m2);
                this.doubleSerde.serialize((Object)this.aDouble, this.m2BytesOutput);
                this.m3Bytes.reset();
                this.aDouble.setValue(m3);
                this.doubleSerde.serialize((Object)this.aDouble, this.m3BytesOutput);
                this.m4Bytes.reset();
                this.aDouble.setValue(m4);
                this.doubleSerde.serialize((Object)this.aDouble, this.m4BytesOutput);
                this.countBytes.reset();
                this.aInt64.setValue(count);
                this.longSerde.serialize((Object)this.aInt64, this.countBytesOutput);
                this.recordEval.evaluate(null, this.resultBytes);
                result.write(this.resultBytes.getByteArray(), this.resultBytes.getStartOffset(), this.resultBytes.getLength());
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void processPartialResults(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        double m1 = BufferSerDeUtil.getDouble(state, start + 0);
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        double m3 = BufferSerDeUtil.getDouble(state, start + 16);
        double m4 = BufferSerDeUtil.getDouble(state, start + 24);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        this.moments.set(m1, m2, m3, m4, count, this.getM3Flag(), this.getM4Flag());
        this.eval.evaluate(tuple, this.inputVal);
        byte[] serBytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(serBytes[offset]);
        switch (typeTag) {
            case NULL: {
                this.processNull(state, start);
                break;
            }
            case SYSTEM_NULL: {
                break;
            }
            case OBJECT: {
                ATypeTag aggType = ATypeTag.DOUBLE;
                int nullBitmapSize = 0;
                int offset1 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)0, (int)nullBitmapSize, (boolean)false);
                int offset2 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)1, (int)nullBitmapSize, (boolean)false);
                int offset3 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)2, (int)nullBitmapSize, (boolean)false);
                int offset4 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)3, (int)nullBitmapSize, (boolean)false);
                int offset5 = ARecordSerializerDeserializer.getFieldOffsetById((byte[])serBytes, (int)offset, (int)4, (int)nullBitmapSize, (boolean)false);
                double temp_m1 = ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset1);
                double temp_m2 = ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset2);
                double temp_m3 = ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset3);
                double temp_m4 = ADoubleSerializerDeserializer.getDouble((byte[])serBytes, (int)offset4);
                long temp_count = AInt64SerializerDeserializer.getLong((byte[])serBytes, (int)offset5);
                this.moments.combine(temp_m1, temp_m2, temp_m3, temp_m4, temp_count);
                BufferSerDeUtil.writeDouble(this.moments.getM1(), state, start + 0);
                BufferSerDeUtil.writeDouble(this.moments.getM2(), state, start + 8);
                BufferSerDeUtil.writeDouble(this.moments.getM3(), state, start + 16);
                BufferSerDeUtil.writeDouble(this.moments.getM4(), state, start + 24);
                BufferSerDeUtil.writeLong(this.moments.getCount(), state, start + 32);
                state[start + 40] = aggType.serialize();
                break;
            }
            default: {
                throw new UnsupportedItemTypeException(this.sourceLoc, this.getFunctionIdentifier(), serBytes[offset]);
            }
        }
    }

    protected void finishStddevFinalResults(byte[] state, int start, int len, DataOutput result, int delta) throws HyracksDataException {
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        try {
            if (count <= 1L || aggType == ATypeTag.NULL) {
                this.nullSerde.serialize((Object)ANull.NULL, result);
            } else {
                this.aDouble.setValue(Math.sqrt(m2 / (double)(count - (long)delta)));
                this.doubleSerde.serialize((Object)this.aDouble, result);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void finishVarFinalResults(byte[] state, int start, int len, DataOutput result, int delta) throws HyracksDataException {
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        try {
            if (count <= 1L || aggType == ATypeTag.NULL) {
                this.nullSerde.serialize((Object)ANull.NULL, result);
            } else {
                this.aDouble.setValue(m2 / (double)(count - (long)delta));
                this.doubleSerde.serialize((Object)this.aDouble, result);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void finishSkewFinalResults(byte[] state, int start, int len, DataOutput result) throws HyracksDataException {
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        double m3 = BufferSerDeUtil.getDouble(state, start + 16);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        try {
            if (count <= 1L || aggType == ATypeTag.NULL || m2 < Double.MIN_VALUE && m2 > -4.9E-324) {
                this.nullSerde.serialize((Object)ANull.NULL, result);
            } else {
                this.aDouble.setValue(Math.sqrt(count) * m3 / Math.pow(m2, 1.5));
                this.doubleSerde.serialize((Object)this.aDouble, result);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected void finishKurtFinalResults(byte[] state, int start, int len, DataOutput result) throws HyracksDataException {
        double m2 = BufferSerDeUtil.getDouble(state, start + 8);
        double m4 = BufferSerDeUtil.getDouble(state, start + 24);
        long count = BufferSerDeUtil.getLong(state, start + 32);
        ATypeTag aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 40]);
        try {
            if (count <= 1L || aggType == ATypeTag.NULL || m2 < Double.MIN_VALUE && m2 > -4.9E-324) {
                this.nullSerde.serialize((Object)ANull.NULL, result);
            } else {
                this.aDouble.setValue(m4 * (double)count / (m2 * m2 - 3.0));
                this.doubleSerde.serialize((Object)this.aDouble, result);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected boolean skipStep(byte[] state, int start) {
        return false;
    }
}

