/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AMutableDouble;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.aggregates.serializable.std.AbstractSerializableAggregateFunction;
import org.apache.asterix.runtime.aggregates.serializable.std.BufferSerDeUtil;
import org.apache.asterix.runtime.exceptions.OverflowException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSerializableSumAggregateFunction
extends AbstractSerializableAggregateFunction {
    private final IEvaluatorContext context;
    private boolean isWarned = false;
    protected static final int AGG_TYPE_OFFSET = 0;
    private static final int SUM_OFFSET = 1;
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;
    protected ATypeTag aggType;
    private AMutableInt64 aInt64 = new AMutableInt64(0L);
    private AMutableDouble aDouble = new AMutableDouble(0.0);
    private boolean isUseInt64ForResult = true;
    private ISerializerDeserializer aInt64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer aDoubleSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ADOUBLE);

    public AbstractSerializableSumAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.context = context;
        this.eval = args[0].createScalarEvaluator(context);
    }

    protected abstract boolean skipStep(byte[] var1, int var2);

    protected abstract void processNull(byte[] var1, int var2);

    protected abstract void processSystemNull() throws HyracksDataException;

    protected abstract void finishNull(DataOutput var1) throws IOException;

    protected abstract void finishSystemNull(DataOutput var1) throws IOException;

    public void init(DataOutput state) throws HyracksDataException {
        try {
            state.writeByte(ATypeTag.SERIALIZED_SYSTEM_NULL_TYPE_TAG);
            state.writeLong(0L);
            this.isWarned = false;
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void step(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        if (this.skipStep(state, start)) {
            return;
        }
        this.eval.evaluate(tuple, this.inputVal);
        byte[] bytes = this.inputVal.getByteArray();
        int offset = this.inputVal.getStartOffset();
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(bytes[offset]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull(state, start);
            return;
        }
        switch (typeTag) {
            case TINYINT: {
                byte val = AInt8SerializerDeserializer.getByte((byte[])bytes, (int)(offset + 1));
                this.processInt64Value(state, start, val);
                break;
            }
            case SMALLINT: {
                short val = AInt16SerializerDeserializer.getShort((byte[])bytes, (int)(offset + 1));
                this.processInt64Value(state, start, val);
                break;
            }
            case INTEGER: {
                int val = AInt32SerializerDeserializer.getInt((byte[])bytes, (int)(offset + 1));
                this.processInt64Value(state, start, val);
                break;
            }
            case BIGINT: {
                long val = AInt64SerializerDeserializer.getLong((byte[])bytes, (int)(offset + 1));
                this.processInt64Value(state, start, val);
                break;
            }
            case FLOAT: {
                this.upgradeOutputType();
                float val = AFloatSerializerDeserializer.getFloat((byte[])bytes, (int)(offset + 1));
                this.processFloatValue(state, start, val);
                break;
            }
            case DOUBLE: {
                this.upgradeOutputType();
                double val = ADoubleSerializerDeserializer.getDouble((byte[])bytes, (int)(offset + 1));
                this.processFloatValue(state, start, val);
                break;
            }
            case SYSTEM_NULL: {
                this.processSystemNull();
                break;
            }
            default: {
                if (!this.isWarned) {
                    this.isWarned = true;
                    ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.context, (SourceLocation)this.sourceLoc, (String)this.getIdentifier().getName(), (ATypeTag)typeTag);
                }
                this.processNull(state, start);
            }
        }
    }

    private void upgradeOutputType() {
        this.isUseInt64ForResult = false;
    }

    private void processInt64Value(byte[] state, int start, long value) throws HyracksDataException {
        if (!this.isUseInt64ForResult) {
            this.processFloatValue(state, start, value);
        } else {
            try {
                long sum = BufferSerDeUtil.getLong(state, start + 1);
                sum = Math.addExact(sum, value);
                state[start + 0] = ATypeTag.SERIALIZED_INT64_TYPE_TAG;
                BufferSerDeUtil.writeLong(sum, state, start + 1);
            }
            catch (ArithmeticException ignored) {
                throw new OverflowException(this.sourceLoc, this.getIdentifier());
            }
        }
    }

    private void processFloatValue(byte[] state, int start, double value) {
        this.aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 0]);
        double sum = this.aggType == ATypeTag.BIGINT || this.aggType == ATypeTag.SYSTEM_NULL ? (double)BufferSerDeUtil.getLong(state, start + 1) : BufferSerDeUtil.getDouble(state, start + 1);
        state[start + 0] = ATypeTag.SERIALIZED_DOUBLE_TYPE_TAG;
        BufferSerDeUtil.writeDouble(sum += value, state, start + 1);
    }

    public void finishPartial(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        this.finishFinal(state, start, len, out);
    }

    public void finish(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        this.finishFinal(state, start, len, out);
    }

    private void finishFinal(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        this.aggType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(state[start + 0]);
        try {
            if (this.aggType == ATypeTag.SYSTEM_NULL) {
                this.finishSystemNull(out);
            } else if (this.aggType == ATypeTag.NULL) {
                this.finishNull(out);
            } else if (this.isUseInt64ForResult) {
                long sum = BufferSerDeUtil.getLong(state, start + 1);
                this.aInt64.setValue(sum);
                this.aInt64Serde.serialize((Object)this.aInt64, out);
            } else {
                double sum = BufferSerDeUtil.getDouble(state, start + 1);
                this.aDouble.setValue(sum);
                this.aDoubleSerde.serialize((Object)this.aDouble, out);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.SUM;
    }
}

