/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.ondisk;

import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;

public abstract class AbstractInvertedListTupleReference
implements IInvertedListTupleReference {
    protected final ITypeTraits[] typeTraits;
    protected final int[] fieldStartOffsets;
    protected byte[] data;
    protected int startOff;

    protected abstract void verifyTypeTrait() throws HyracksDataException;

    public AbstractInvertedListTupleReference(ITypeTraits[] typeTraits) throws HyracksDataException {
        this.typeTraits = typeTraits;
        this.fieldStartOffsets = new int[typeTraits.length];
        this.fieldStartOffsets[0] = 0;
        this.verifyTypeTrait();
    }

    protected abstract void calculateFieldStartOffsets();

    @Override
    public void reset(byte[] data, int startOff) {
        this.data = data;
        this.startOff = startOff;
        this.calculateFieldStartOffsets();
    }

    public int getFieldCount() {
        return this.typeTraits.length;
    }

    public byte[] getFieldData(int fIdx) {
        return this.data;
    }

    public int getFieldStart(int fIdx) {
        return this.startOff + this.fieldStartOffsets[fIdx];
    }
}

