/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.std;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.EvaluatorContext;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputOneFramePushRuntime;
import org.apache.hyracks.algebricks.runtime.operators.base.AbstractOneInputOneOutputRuntimeFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class AssignRuntimeFactory
extends AbstractOneInputOneOutputRuntimeFactory {
    private static final long serialVersionUID = 1L;
    private int[] outColumns;
    private IScalarEvaluatorFactory[] evalFactories;
    private final boolean flushFramesRapidly;

    public AssignRuntimeFactory(int[] outColumns, IScalarEvaluatorFactory[] evalFactories, int[] projectionList) {
        this(outColumns, evalFactories, projectionList, false);
    }

    public AssignRuntimeFactory(int[] outColumns, IScalarEvaluatorFactory[] evalFactories, int[] projectionList, boolean flushFramesRapidly) {
        super(projectionList);
        this.outColumns = outColumns;
        this.evalFactories = evalFactories;
        this.flushFramesRapidly = flushFramesRapidly;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("assign [");
        for (i = 0; i < this.outColumns.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.outColumns[i]);
        }
        sb.append("] := [");
        for (i = 0; i < this.evalFactories.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.evalFactories[i].toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public AbstractOneInputOneOutputOneFramePushRuntime createOneOutputPushRuntime(final IHyracksTaskContext ctx) throws HyracksDataException {
        final EvaluatorContext evalCtx = new EvaluatorContext(ctx);
        final int[] projectionToOutColumns = new int[this.projectionList.length];
        for (int j = 0; j < this.projectionList.length; ++j) {
            projectionToOutColumns[j] = Arrays.binarySearch(this.outColumns, this.projectionList[j]);
        }
        return new AbstractOneInputOneOutputOneFramePushRuntime(){
            private IPointable result = VoidPointable.FACTORY.createPointable();
            private IScalarEvaluator[] eval = new IScalarEvaluator[AssignRuntimeFactory.access$000(AssignRuntimeFactory.this).length];
            private ArrayTupleBuilder tupleBuilder = new ArrayTupleBuilder(AssignRuntimeFactory.access$100(AssignRuntimeFactory.this).length);
            private boolean first = true;
            private int tupleIndex = 0;

            @Override
            public void open() throws HyracksDataException {
                if (this.first) {
                    this.initAccessAppendRef(ctx);
                    this.first = false;
                    int n = AssignRuntimeFactory.this.evalFactories.length;
                    for (int i = 0; i < n; ++i) {
                        this.eval[i] = AssignRuntimeFactory.this.evalFactories[i].createScalarEvaluator(evalCtx);
                    }
                }
                super.open();
            }

            public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                this.tAccess.reset(buffer);
                int nTuple = this.tAccess.getTupleCount();
                if (nTuple < 1) {
                    if (nTuple < 0) {
                        throw new HyracksDataException("Negative number of tuples in the frame: " + nTuple);
                    }
                    this.appender.flush(this.writer);
                } else {
                    if (nTuple > 1) {
                        while (this.tupleIndex < nTuple - 1) {
                            this.tRef.reset((IFrameTupleAccessor)this.tAccess, this.tupleIndex);
                            this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, this.tupleIndex, this.tRef);
                            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                            ++this.tupleIndex;
                        }
                    }
                    if (this.tupleIndex < nTuple) {
                        this.tRef.reset((IFrameTupleAccessor)this.tAccess, this.tupleIndex);
                        this.produceTuple(this.tupleBuilder, (IFrameTupleAccessor)this.tAccess, this.tupleIndex, this.tRef);
                        if (AssignRuntimeFactory.this.flushFramesRapidly) {
                            this.appendToFrameFromTupleBuilder(this.tupleBuilder, true);
                        } else {
                            this.appendToFrameFromTupleBuilder(this.tupleBuilder);
                        }
                    } else if (AssignRuntimeFactory.this.flushFramesRapidly) {
                        this.flushAndReset();
                    }
                }
                this.tupleIndex = 0;
            }

            private void produceTuple(ArrayTupleBuilder tb, IFrameTupleAccessor accessor, int tIndex, FrameTupleReference tupleRef) throws HyracksDataException {
                try {
                    tb.reset();
                    for (int f = 0; f < AssignRuntimeFactory.this.projectionList.length; ++f) {
                        int k = projectionToOutColumns[f];
                        if (k >= 0) {
                            this.eval[k].evaluate((IFrameTupleReference)tupleRef, this.result);
                            tb.addField(this.result.getByteArray(), this.result.getStartOffset(), this.result.getLength());
                            continue;
                        }
                        tb.addField(accessor, tIndex, AssignRuntimeFactory.this.projectionList[f]);
                    }
                }
                catch (HyracksDataException e) {
                    throw HyracksDataException.create((int)2, (Throwable)e, (SourceLocation)AssignRuntimeFactory.this.sourceLoc, (Serializable[])new Serializable[]{Integer.valueOf(this.tupleIndex)});
                }
            }

            public void flush() throws HyracksDataException {
                this.appender.flush(this.writer);
            }
        };
    }

    static /* synthetic */ int[] access$100(AssignRuntimeFactory x0) {
        return x0.projectionList;
    }
}

