/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.algebra.operators.physical.IntervalMergeJoinPOperator;
import org.apache.asterix.common.annotations.RangeAnnotation;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.om.functions.BuiltinFunctionInfo;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.rules.util.IntervalPartitions;
import org.apache.asterix.runtime.operators.joins.interval.utils.AfterIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.BeforeIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.CoveredByIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.CoversIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.OverlappedByIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.OverlappingIntervalJoinUtilFactory;
import org.apache.asterix.runtime.operators.joins.interval.utils.OverlapsIntervalJoinUtilFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AssignPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IntervalColumn;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class IntervalJoinUtils {
    private static final Map<FunctionIdentifier, FunctionIdentifier> INTERVAL_JOIN_CONDITIONS = new HashMap<FunctionIdentifier, FunctionIdentifier>();

    protected static RangeAnnotation findRangeAnnotation(AbstractFunctionCallExpression fexp) {
        for (IExpressionAnnotation annotation : fexp.getAnnotations().values()) {
            if (!(annotation instanceof RangeAnnotation)) continue;
            return (RangeAnnotation)annotation;
        }
        return null;
    }

    protected static void setSortMergeIntervalJoinOp(AbstractBinaryJoinOperator op, FunctionIdentifier fi, List<LogicalVariable> sideLeft, List<LogicalVariable> sideRight, IOptimizationContext context, IntervalPartitions intervalPartitions) throws CompilationException {
        IIntervalJoinUtilFactory mjcf = IntervalJoinUtils.createIntervalJoinCheckerFactory(fi, intervalPartitions.getRangeMap());
        op.setPhysicalOperator((IPhysicalOperator)new IntervalMergeJoinPOperator(op.getJoinKind(), AbstractJoinPOperator.JoinPartitioningType.BROADCAST, sideLeft, sideRight, context.getPhysicalOptimizationConfig().getMaxFramesForJoin(), mjcf, intervalPartitions));
    }

    protected static IntervalPartitions createIntervalPartitions(AbstractBinaryJoinOperator op, FunctionIdentifier fi, List<LogicalVariable> sideLeft, List<LogicalVariable> sideRight, RangeMap rangeMap, IOptimizationContext context, int left, int right) throws AlgebricksException {
        ArrayList<LogicalVariable> leftPartitionVar = new ArrayList<LogicalVariable>(2);
        leftPartitionVar.add(context.newVar());
        leftPartitionVar.add(context.newVar());
        ArrayList<LogicalVariable> rightPartitionVar = new ArrayList<LogicalVariable>(2);
        rightPartitionVar.add(context.newVar());
        rightPartitionVar.add(context.newVar());
        IntervalJoinUtils.insertPartitionSortKey(op, left, leftPartitionVar, sideLeft.get(0), context);
        IntervalJoinUtils.insertPartitionSortKey(op, right, rightPartitionVar, sideRight.get(0), context);
        List<IntervalColumn> leftIC = Collections.singletonList(new IntervalColumn((LogicalVariable)leftPartitionVar.get(0), (LogicalVariable)leftPartitionVar.get(1), OrderOperator.IOrder.OrderKind.ASC));
        List<IntervalColumn> rightIC = Collections.singletonList(new IntervalColumn((LogicalVariable)rightPartitionVar.get(0), (LogicalVariable)rightPartitionVar.get(1), OrderOperator.IOrder.OrderKind.ASC));
        IPartitioningProperty.PartitioningType leftPartitioningType = IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED;
        IPartitioningProperty.PartitioningType rightPartitioningType = IPartitioningProperty.PartitioningType.ORDERED_PARTITIONED;
        if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPED_BY)) {
            rightPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPS)) {
            leftPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPING)) {
            leftPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
            rightPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_COVERS)) {
            leftPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_COVERED_BY)) {
            rightPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_INTERSECT;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_BEFORE)) {
            leftPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_FOLLOWING;
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_AFTER)) {
            rightPartitioningType = IPartitioningProperty.PartitioningType.PARTIAL_BROADCAST_ORDERED_FOLLOWING;
        } else {
            throw new CompilationException(1038, new Serializable[]{fi.getName()});
        }
        return new IntervalPartitions(rangeMap, leftIC, rightIC, leftPartitioningType, rightPartitioningType);
    }

    protected static FunctionIdentifier isIntervalJoinCondition(ILogicalExpression e, Collection<LogicalVariable> inLeftAll, Collection<LogicalVariable> inRightAll, Collection<LogicalVariable> outLeftFields, Collection<LogicalVariable> outRightFields, int left, int right) {
        boolean switchArguments = false;
        if (e.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (!IntervalJoinUtils.isIntervalFunction(fi)) {
            return null;
        }
        FunctionIdentifier fiReturn = fi;
        ILogicalExpression opLeft = (ILogicalExpression)((Mutable)fexp.getArguments().get(left)).getValue();
        ILogicalExpression opRight = (ILogicalExpression)((Mutable)fexp.getArguments().get(right)).getValue();
        if (opLeft.getExpressionTag() != LogicalExpressionTag.VARIABLE || opRight.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
            return null;
        }
        LogicalVariable var1 = ((VariableReferenceExpression)opLeft).getVariableReference();
        if (inLeftAll.contains(var1) && !outLeftFields.contains(var1)) {
            outLeftFields.add(var1);
        } else if (inRightAll.contains(var1) && !outRightFields.contains(var1)) {
            outRightFields.add(var1);
            fiReturn = IntervalJoinUtils.getInverseIntervalFunction(fi);
            switchArguments = true;
        } else {
            return null;
        }
        LogicalVariable var2 = ((VariableReferenceExpression)opRight).getVariableReference();
        if (inLeftAll.contains(var2) && !outLeftFields.contains(var2) && switchArguments) {
            outLeftFields.add(var2);
        } else if (inRightAll.contains(var2) && !outRightFields.contains(var2) && !switchArguments) {
            outRightFields.add(var2);
        } else {
            return null;
        }
        return fiReturn;
    }

    private static IIntervalJoinUtilFactory createIntervalJoinCheckerFactory(FunctionIdentifier fi, RangeMap rangeMap) throws CompilationException {
        OverlappedByIntervalJoinUtilFactory mjcf;
        if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPED_BY)) {
            mjcf = new OverlappedByIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPS)) {
            mjcf = new OverlapsIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_COVERS)) {
            mjcf = new CoversIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_COVERED_BY)) {
            mjcf = new CoveredByIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_BEFORE)) {
            mjcf = new BeforeIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_AFTER)) {
            mjcf = new AfterIntervalJoinUtilFactory();
        } else if (fi.equals((Object)BuiltinFunctions.INTERVAL_OVERLAPPING)) {
            mjcf = new OverlappingIntervalJoinUtilFactory(rangeMap);
        } else {
            throw new CompilationException(1038, new Serializable[]{fi.getName()});
        }
        return mjcf;
    }

    private static boolean isIntervalFunction(FunctionIdentifier fi) {
        return INTERVAL_JOIN_CONDITIONS.containsKey(fi);
    }

    private static FunctionIdentifier getInverseIntervalFunction(FunctionIdentifier fi) {
        return INTERVAL_JOIN_CONDITIONS.get(fi);
    }

    private static void insertPartitionSortKey(AbstractBinaryJoinOperator op, int branch, List<LogicalVariable> partitionVars, LogicalVariable intervalVar, IOptimizationContext context) throws AlgebricksException {
        MutableObject intervalExp = new MutableObject((Object)new VariableReferenceExpression(intervalVar));
        ArrayList<MutableObject> assignExps = new ArrayList<MutableObject>();
        BuiltinFunctionInfo startFi = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.ACCESSOR_TEMPORAL_INTERVAL_START);
        ScalarFunctionCallExpression startPartitionExp = new ScalarFunctionCallExpression((IFunctionInfo)startFi, new Mutable[]{intervalExp});
        assignExps.add(new MutableObject((Object)startPartitionExp));
        BuiltinFunctionInfo endFi = FunctionUtil.getFunctionInfo((FunctionIdentifier)BuiltinFunctions.ACCESSOR_TEMPORAL_INTERVAL_END);
        ScalarFunctionCallExpression endPartitionExp = new ScalarFunctionCallExpression((IFunctionInfo)endFi, new Mutable[]{intervalExp});
        assignExps.add(new MutableObject((Object)endPartitionExp));
        AssignOperator ao = new AssignOperator(partitionVars, assignExps);
        ao.setSourceLocation(op.getSourceLocation());
        ao.setExecutionMode(op.getExecutionMode());
        AssignPOperator apo = new AssignPOperator();
        ao.setPhysicalOperator((IPhysicalOperator)apo);
        MutableObject aoRef = new MutableObject((Object)ao);
        ao.getInputs().add(op.getInputs().get(branch));
        op.getInputs().set(branch, aoRef);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)ao);
        ao.recomputeSchema();
    }

    static {
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_AFTER, BuiltinFunctions.INTERVAL_BEFORE);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_BEFORE, BuiltinFunctions.INTERVAL_AFTER);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_COVERED_BY, BuiltinFunctions.INTERVAL_COVERS);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_COVERS, BuiltinFunctions.INTERVAL_COVERED_BY);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_OVERLAPPED_BY, BuiltinFunctions.INTERVAL_OVERLAPS);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_OVERLAPPING, BuiltinFunctions.INTERVAL_OVERLAPPING);
        INTERVAL_JOIN_CONDITIONS.put(BuiltinFunctions.INTERVAL_OVERLAPS, BuiltinFunctions.INTERVAL_OVERLAPPED_BY);
    }
}

