/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.SynchronizableWork;

public class GetJobSummariesJSONWork
extends SynchronizableWork {
    private final IJobManager jobManager;
    private ArrayNode summaries;

    public GetJobSummariesJSONWork(IJobManager jobManager) {
        this.jobManager = jobManager;
    }

    protected void doRun() throws Exception {
        ObjectMapper om = new ObjectMapper();
        this.summaries = om.createArrayNode();
        this.populateJSON(this.jobManager.getRunningJobs());
        this.populateJSON(this.jobManager.getPendingJobs());
        this.populateJSON(this.jobManager.getArchivedJobs());
    }

    private void populateJSON(Collection<JobRun> jobRuns) {
        ObjectMapper om = new ObjectMapper();
        for (JobRun run : jobRuns) {
            ObjectNode jo = om.createObjectNode();
            jo.put("type", "job-summary");
            jo.put("job-id", run.getJobId().toString());
            jo.put("create-time", run.getCreateTime());
            jo.put("start-time", run.getStartTime());
            jo.put("end-time", run.getEndTime());
            jo.put("status", run.getStatus().toString());
            this.summaries.add((JsonNode)jo);
        }
    }

    public ArrayNode getSummaries() {
        return this.summaries;
    }
}

