/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.NodeControllerState;
import org.apache.hyracks.control.cc.cluster.INodeManager;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetThreadDumpWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int TIMEOUT_SECS = 60;
    private final ClusterControllerService ccs;
    private final String nodeId;
    private final IResultCallback<String> callback;
    private final ThreadDumpRun run;

    public GetThreadDumpWork(ClusterControllerService ccs, String nodeId, IResultCallback<String> callback) {
        this.ccs = ccs;
        this.nodeId = nodeId;
        this.callback = callback;
        this.run = new ThreadDumpRun(UUID.randomUUID().toString());
    }

    public void run() {
        if (this.nodeId == null) {
            try {
                this.callback.setValue((Object)ThreadDumpUtil.takeDumpJSONString());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARN, "Exception taking CC thread dump", (Throwable)e);
                this.callback.setException(e);
            }
        } else {
            INodeManager nodeManager = this.ccs.getNodeManager();
            NodeControllerState ncState = nodeManager.getNodeControllerState(this.nodeId);
            if (ncState == null) {
                this.callback.setValue(null);
            } else {
                this.ccs.addThreadDumpRun(this.run.getRequestId(), this.run);
                try {
                    ncState.getNodeController().takeThreadDump(this.run.getRequestId());
                }
                catch (Exception e) {
                    this.ccs.removeThreadDumpRun(this.run.getRequestId());
                    this.callback.setException(e);
                }
                long requestTime = System.currentTimeMillis();
                this.ccs.getExecutor().execute(() -> {
                    try {
                        long queueTime = System.currentTimeMillis() - requestTime;
                        long sleepTime = TimeUnit.SECONDS.toMillis(60L) - queueTime;
                        if (sleepTime > 0L) {
                            Thread.sleep(sleepTime);
                        }
                        if (this.ccs.removeThreadDumpRun(this.run.getRequestId()) != null) {
                            LOGGER.log(Level.WARN, "Timed out thread dump request " + this.run.getRequestId() + " for node " + this.nodeId);
                            this.callback.setException((Exception)new TimeoutException("Thread dump request for node " + this.nodeId + " timed out after " + 60 + " seconds."));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                });
            }
        }
    }

    public class ThreadDumpRun {
        private final String requestId;

        public ThreadDumpRun(String requestId) {
            this.requestId = requestId;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public synchronized void notifyThreadDumpReceived(String threadDumpJSON) {
            GetThreadDumpWork.this.callback.setValue((Object)threadDumpJSON);
        }
    }
}

