/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.util;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Random;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;

public class FeedFrameUtil {
    public static ByteBuffer removeBadTuple(IHyracksTaskContext ctx, int tupleIndex, FrameTupleAccessor fta) throws HyracksDataException {
        FrameTupleAppender appender = new FrameTupleAppender();
        VSizeFrame slicedFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        appender.reset((IFrame)slicedFrame, true);
        int totalTuples = fta.getTupleCount();
        for (int ti = 0; ti < totalTuples; ++ti) {
            if (ti == tupleIndex) continue;
            appender.append((IFrameTupleAccessor)fta, ti);
        }
        return slicedFrame.getBuffer();
    }

    public static ByteBuffer getSampledFrame(IHyracksTaskContext ctx, FrameTupleAccessor fta, int sampleSize) throws HyracksDataException {
        NChooseKIterator it = new NChooseKIterator(fta.getTupleCount(), sampleSize);
        FrameTupleAppender appender = new FrameTupleAppender();
        VSizeFrame sampledFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        appender.reset((IFrame)sampledFrame, true);
        int nextTupleIndex = 0;
        while (it.hasNext()) {
            nextTupleIndex = it.next();
            appender.append((IFrameTupleAccessor)fta, nextTupleIndex);
        }
        return sampledFrame.getBuffer();
    }

    private static class NChooseKIterator {
        private final int n;
        private final int k;
        private final BitSet bSet;
        private final Random random;
        private int traversed = 0;

        public NChooseKIterator(int n, int k) {
            this.n = n;
            this.k = k;
            this.bSet = new BitSet(n);
            this.bSet.set(0, n - 1);
            this.random = new Random();
        }

        public boolean hasNext() {
            return this.traversed < this.k;
        }

        public int next() {
            if (this.hasNext()) {
                ++this.traversed;
                int startOffset = this.random.nextInt(this.n);
                int pos = -1;
                while (pos < 0) {
                    pos = this.bSet.nextSetBit(startOffset);
                    if (pos >= 0) continue;
                    startOffset = 0;
                }
                this.bSet.clear(pos);
                return pos;
            }
            return -1;
        }
    }
}

