/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.api.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.PrintWriter;
import java.util.concurrent.ConcurrentMap;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.app.active.ActiveNotificationHandler;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.external.feed.watch.StatsSubscriber;
import org.apache.hyracks.http.api.IServletRequest;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.AbstractServlet;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveStatsApiServlet
extends AbstractServlet {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_EXPIRE_TIME = 2000;
    private final ActiveNotificationHandler activeNotificationHandler;

    public ActiveStatsApiServlet(ICcApplicationContext appCtx, ConcurrentMap<String, Object> ctx, String ... paths) {
        super(ctx, paths);
        this.activeNotificationHandler = (ActiveNotificationHandler)appCtx.getActiveNotificationHandler();
    }

    private JsonNode constructNode(ObjectMapper om, IActiveEntityEventsListener eventListener, long currentTime, long ttl) throws Exception {
        long statsTimeStamp = eventListener.getStatsTimeStamp();
        if (currentTime - statsTimeStamp > ttl) {
            StatsSubscriber subscriber = new StatsSubscriber(eventListener);
            eventListener.refreshStats(5000L);
            subscriber.sync();
        }
        return om.readTree(eventListener.getStats());
    }

    protected void get(IServletRequest request, IServletResponse response) throws Exception {
        String localPath = this.localPath(request);
        IActiveEntityEventsListener[] listeners = this.activeNotificationHandler.getEventListeners();
        ObjectNode resNode = OBJECT_MAPPER.createObjectNode();
        PrintWriter responseWriter = response.writer();
        try {
            response.setStatus(HttpResponseStatus.OK);
            int expireTime = localPath.length() == 0 || localPath.length() == 1 ? 2000 : Integer.valueOf(localPath.substring(1));
            long currentTime = System.currentTimeMillis();
            for (int iter1 = 0; iter1 < listeners.length; ++iter1) {
                if (!listeners[iter1].isActive()) continue;
                resNode.putPOJO(listeners[iter1].getDisplayName(), (Object)this.constructNode(OBJECT_MAPPER, listeners[iter1], currentTime, expireTime));
            }
            responseWriter.write(OBJECT_MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)resNode));
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "exception thrown for " + request, (Throwable)e);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            responseWriter.write(e.toString());
        }
        responseWriter.flush();
    }
}

