/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.utils;

import java.util.List;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.utils.NonTaggedFormatUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class RecordUtil {
    public static final ARecordType FULLY_OPEN_RECORD_TYPE = new ARecordType("AnyObject", new String[0], new IAType[0], true);

    private RecordUtil() {
    }

    public static String toFullyQualifiedName(List<String> field) {
        return StringUtils.join(field, (String)".");
    }

    public static String toFullyQualifiedName(String ... names) {
        return StringUtils.join((Object[])names, (String)".");
    }

    public static int computeNullBitmapSize(ARecordType recordType) {
        return RecordUtil.computeNullBitmapSize(NonTaggedFormatUtil.hasOptionalField(recordType), recordType);
    }

    public static int computeNullBitmapSize(boolean hasOptionalField, ARecordType recordType) {
        return hasOptionalField ? (int)Math.ceil((double)recordType.getFieldTypes().length / 4.0) : 0;
    }

    public static boolean isNull(byte nullMissingBits, int fieldIndex) {
        int position = 1 << 7 - 2 * (fieldIndex % 4);
        return (nullMissingBits & position) == 0;
    }

    public static boolean isMissing(byte nullMissingBits, int fieldIndex) {
        int position = 1 << 7 - 2 * (fieldIndex % 4) - 1;
        return (nullMissingBits & position) == 0;
    }

    public static IAType getType(ARecordType recordType, int fieldIdx, ATypeTag fieldTag) throws HyracksDataException {
        IAType[] fieldTypes = recordType.getFieldTypes();
        if (fieldIdx >= fieldTypes.length) {
            return fieldTag.isDerivedType() ? DefaultOpenFieldType.getDefaultOpenFieldType(fieldTag) : TypeTagUtil.getBuiltinTypeByTag(fieldTag);
        }
        return fieldTypes[fieldIdx];
    }
}

