/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import reactor.core.Exceptions;
import reactor.netty.ConnectionObserver;
import reactor.netty.ReactorNetty;
import reactor.netty.channel.BootstrapHandlers;
import reactor.netty.channel.ChannelMetricsHandler;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.tcp.TcpClientSecure;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class SslProvider {
    final SslContext sslContext;
    final SslContextBuilder sslContextBuilder;
    final DefaultConfigurationType type;
    final long handshakeTimeoutMillis;
    final long closeNotifyFlushTimeoutMillis;
    final long closeNotifyReadTimeoutMillis;
    final Consumer<? super SslHandler> handlerConfigurator;
    final int builderHashCode;
    static final Logger log = Loggers.getLogger(SslProvider.class);

    public static SslContextSpec builder() {
        return new Build();
    }

    public static SslProvider addHandlerConfigurator(SslProvider provider, Consumer<? super SslHandler> handlerConfigurator) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(handlerConfigurator, "handlerConfigurator");
        return new SslProvider(provider, handlerConfigurator);
    }

    public static SslProvider updateDefaultConfiguration(SslProvider provider, DefaultConfigurationType type) {
        Objects.requireNonNull(provider, "provider");
        Objects.requireNonNull(type, "type");
        return new SslProvider(provider, type);
    }

    public static SslProvider defaultClientProvider() {
        return TcpClientSecure.DEFAULT_CLIENT_PROVIDER;
    }

    public static Bootstrap setBootstrap(Bootstrap b, SslProvider sslProvider) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.sslHandler", new DeferredSslSupport(sslProvider));
        return b;
    }

    @Nullable
    public static SslProvider findSslSupport(Bootstrap b) {
        DeferredSslSupport ssl = BootstrapHandlers.findConfiguration(DeferredSslSupport.class, b.config().handler());
        if (ssl == null) {
            return null;
        }
        return ssl.sslProvider;
    }

    @Nullable
    public static SslProvider findSslSupport(ServerBootstrap b) {
        SslSupportConsumer ssl = BootstrapHandlers.findConfiguration(SslSupportConsumer.class, b.config().childHandler());
        if (ssl == null) {
            return null;
        }
        return ssl.sslProvider;
    }

    public static Bootstrap removeSslSupport(Bootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "reactor.left.sslHandler");
        return b;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SslProvider(Build builder) {
        this.sslContextBuilder = builder.sslCtxBuilder;
        this.type = builder.type;
        if (builder.sslContext == null) {
            if (this.sslContextBuilder == null) throw new IllegalArgumentException("Neither SslContextBuilder nor SslContext is specified");
            if (this.type != null) {
                this.updateDefaultConfiguration();
            }
            try {
                this.sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            this.sslContext = builder.sslContext;
        }
        this.handlerConfigurator = builder.handlerConfigurator;
        this.handshakeTimeoutMillis = builder.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = builder.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = builder.closeNotifyReadTimeoutMillis;
        this.builderHashCode = builder.hashCode();
    }

    SslProvider(SslProvider from, Consumer<? super SslHandler> handlerConfigurator) {
        this.sslContext = from.sslContext;
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = from.type;
        this.handlerConfigurator = from.handlerConfigurator == null ? handlerConfigurator : h -> {
            handlerConfigurator.accept((SslHandler)h);
            from.handlerConfigurator.accept((SslHandler)h);
        };
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
        this.builderHashCode = from.builderHashCode;
    }

    SslProvider(SslProvider from, DefaultConfigurationType type) {
        this.sslContextBuilder = from.sslContextBuilder;
        this.type = type;
        if (this.sslContextBuilder != null) {
            this.updateDefaultConfiguration();
            try {
                this.sslContext = this.sslContextBuilder.build();
            }
            catch (SSLException e) {
                throw Exceptions.propagate((Throwable)e);
            }
        } else {
            this.sslContext = from.sslContext;
        }
        this.handlerConfigurator = from.handlerConfigurator;
        this.handshakeTimeoutMillis = from.handshakeTimeoutMillis;
        this.closeNotifyFlushTimeoutMillis = from.closeNotifyFlushTimeoutMillis;
        this.closeNotifyReadTimeoutMillis = from.closeNotifyReadTimeoutMillis;
        this.builderHashCode = from.builderHashCode;
    }

    void updateDefaultConfiguration() {
        switch (this.type) {
            case H2: {
                this.sslContextBuilder.sslProvider(io.netty.handler.ssl.SslProvider.isAlpnSupported((io.netty.handler.ssl.SslProvider)io.netty.handler.ssl.SslProvider.OPENSSL) ? io.netty.handler.ssl.SslProvider.OPENSSL : io.netty.handler.ssl.SslProvider.JDK).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).applicationProtocolConfig(new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"}));
                break;
            }
            case TCP: {
                this.sslContextBuilder.sslProvider(OpenSsl.isAvailable() ? io.netty.handler.ssl.SslProvider.OPENSSL : io.netty.handler.ssl.SslProvider.JDK);
                break;
            }
        }
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    @Nullable
    public DefaultConfigurationType getDefaultConfigurationType() {
        return this.type;
    }

    public void configure(SslHandler sslHandler) {
        sslHandler.setHandshakeTimeoutMillis(this.handshakeTimeoutMillis);
        sslHandler.setCloseNotifyFlushTimeoutMillis(this.closeNotifyFlushTimeoutMillis);
        sslHandler.setCloseNotifyReadTimeoutMillis(this.closeNotifyReadTimeoutMillis);
        if (this.handlerConfigurator != null) {
            this.handlerConfigurator.accept((SslHandler)sslHandler);
        }
    }

    public String asSimpleString() {
        return this.toString();
    }

    public String asDetailedString() {
        return "handshakeTimeoutMillis=" + this.handshakeTimeoutMillis + ", closeNotifyFlushTimeoutMillis=" + this.closeNotifyFlushTimeoutMillis + ", closeNotifyReadTimeoutMillis=" + this.closeNotifyReadTimeoutMillis;
    }

    public String toString() {
        return "SslProvider{" + this.asDetailedString() + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslProvider that = (SslProvider)o;
        return this.builderHashCode == that.builderHashCode;
    }

    public int hashCode() {
        return Objects.hash(this.builderHashCode);
    }

    static ServerBootstrap removeSslSupport(ServerBootstrap b) {
        BootstrapHandlers.removeConfiguration(b, "reactor.left.sslHandler");
        return b;
    }

    public static ServerBootstrap setBootstrap(ServerBootstrap b, SslProvider sslProvider) {
        BootstrapHandlers.updateConfiguration(b, "reactor.left.sslHandler", (BiConsumer<ConnectionObserver, ? super Channel>)new SslSupportConsumer(sslProvider, null));
        return b;
    }

    static final class SslReadHandler
    extends ChannelInboundHandlerAdapter {
        boolean handshakeDone;
        ChannelMetricsRecorder recorder;
        long tlsHandshakeTimeStart;

        SslReadHandler() {
        }

        public void channelRegistered(ChannelHandlerContext ctx) {
            ChannelHandler handler = ctx.pipeline().get("reactor.left.channelMetricsHandler");
            if (handler != null) {
                this.recorder = ((ChannelMetricsHandler)handler).recorder();
                this.tlsHandshakeTimeStart = System.nanoTime();
            }
            ctx.fireChannelRegistered();
        }

        public void channelActive(ChannelHandlerContext ctx) {
            ctx.read();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) {
            if (!this.handshakeDone) {
                ctx.read();
            }
            ctx.fireChannelReadComplete();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshake;
                this.handshakeDone = true;
                if (ctx.pipeline().context((ChannelHandler)this) != null) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
                if ((handshake = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                    if (this.recorder != null) {
                        this.recorder.recordTlsHandshakeTime(ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - this.tlsHandshakeTimeStart), "SUCCESS");
                    }
                    ctx.fireChannelActive();
                } else {
                    if (this.recorder != null) {
                        this.recorder.recordTlsHandshakeTime(ctx.channel().remoteAddress(), Duration.ofNanos(System.nanoTime() - this.tlsHandshakeTimeStart), "ERROR");
                    }
                    ctx.fireExceptionCaught(handshake.cause());
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    static final class SslSupportConsumer
    implements BiConsumer<ConnectionObserver, Channel> {
        final SslProvider sslProvider;
        final InetSocketAddress sniInfo;

        SslSupportConsumer(SslProvider sslProvider, @Nullable SocketAddress sniInfo) {
            this.sslProvider = sslProvider;
            this.sniInfo = sniInfo instanceof InetSocketAddress ? (InetSocketAddress)sniInfo : null;
        }

        @Override
        public void accept(ConnectionObserver listener, Channel channel) {
            SslHandler sslHandler;
            if (this.sniInfo != null) {
                sslHandler = this.sslProvider.getSslContext().newHandler(channel.alloc(), this.sniInfo.getHostString(), this.sniInfo.getPort());
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "SSL enabled using engine {} and SNI {}"), new Object[]{sslHandler.engine().getClass().getSimpleName(), this.sniInfo});
                }
            } else {
                sslHandler = this.sslProvider.getSslContext().newHandler(channel.alloc());
                if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "SSL enabled using engine {}"), new Object[]{sslHandler.engine().getClass().getSimpleName()});
                }
            }
            this.sslProvider.configure(sslHandler);
            if (channel.pipeline().get("reactor.left.proxyHandler") != null) {
                channel.pipeline().addAfter("reactor.left.proxyHandler", "reactor.left.sslHandler", (ChannelHandler)sslHandler);
            } else if (channel.pipeline().get("reactor.left.proxyProtocolReader") != null) {
                channel.pipeline().addAfter("reactor.left.proxyProtocolReader", "reactor.left.sslHandler", (ChannelHandler)sslHandler);
            } else {
                channel.pipeline().addFirst("reactor.left.sslHandler", (ChannelHandler)sslHandler);
            }
            if (channel.pipeline().get("reactor.left.loggingHandler") != null) {
                channel.pipeline().addAfter("reactor.left.loggingHandler", "reactor.left.sslReader", (ChannelHandler)new SslReadHandler());
            } else {
                channel.pipeline().addAfter("reactor.left.sslHandler", "reactor.left.sslReader", (ChannelHandler)new SslReadHandler());
            }
        }
    }

    static final class DeferredSslSupport
    implements Function<Bootstrap, BiConsumer<ConnectionObserver, Channel>> {
        final SslProvider sslProvider;

        DeferredSslSupport(SslProvider sslProvider) {
            this.sslProvider = sslProvider;
        }

        @Override
        public BiConsumer<ConnectionObserver, Channel> apply(Bootstrap bootstrap) {
            return new SslSupportConsumer(this.sslProvider, bootstrap.config().remoteAddress());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeferredSslSupport that = (DeferredSslSupport)o;
            return Objects.equals(this.sslProvider, that.sslProvider);
        }

        public int hashCode() {
            return Objects.hash(this.sslProvider);
        }
    }

    static final class Build
    implements SslContextSpec,
    DefaultConfigurationSpec,
    Builder {
        static final long DEFAULT_SSL_HANDSHAKE_TIMEOUT = Long.parseLong(System.getProperty("reactor.netty.tcp.sslHandshakeTimeout", "10000"));
        SslContextBuilder sslCtxBuilder;
        DefaultConfigurationType type;
        SslContext sslContext;
        Consumer<? super SslHandler> handlerConfigurator;
        long handshakeTimeoutMillis = DEFAULT_SSL_HANDSHAKE_TIMEOUT;
        long closeNotifyFlushTimeoutMillis = 3000L;
        long closeNotifyReadTimeoutMillis;

        Build() {
        }

        @Override
        public final Builder sslContext(SslContext sslContext) {
            this.sslContext = Objects.requireNonNull(sslContext, "sslContext");
            return this;
        }

        @Override
        public final DefaultConfigurationSpec sslContext(SslContextBuilder sslCtxBuilder) {
            this.sslCtxBuilder = Objects.requireNonNull(sslCtxBuilder, "sslCtxBuilder");
            return this;
        }

        @Override
        public final Builder defaultConfiguration(DefaultConfigurationType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @Override
        public final Builder handshakeTimeout(Duration handshakeTimeout) {
            Objects.requireNonNull(handshakeTimeout, "handshakeTimeout");
            return this.handshakeTimeoutMillis(handshakeTimeout.toMillis());
        }

        @Override
        public final Builder handlerConfigurator(Consumer<? super SslHandler> handlerConfigurator) {
            Objects.requireNonNull(handlerConfigurator, "handshakeTimeout");
            this.handlerConfigurator = handlerConfigurator;
            return this;
        }

        @Override
        public final Builder handshakeTimeoutMillis(long handshakeTimeoutMillis) {
            if (handshakeTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl handshake timeout must be positive was: " + handshakeTimeoutMillis);
            }
            this.handshakeTimeoutMillis = handshakeTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyFlushTimeout(Duration closeNotifyFlushTimeout) {
            Objects.requireNonNull(closeNotifyFlushTimeout, "closeNotifyFlushTimeout");
            return this.closeNotifyFlushTimeoutMillis(closeNotifyFlushTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyFlushTimeoutMillis(long closeNotifyFlushTimeoutMillis) {
            if (closeNotifyFlushTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify flush timeout must be positive, was: " + closeNotifyFlushTimeoutMillis);
            }
            this.closeNotifyFlushTimeoutMillis = closeNotifyFlushTimeoutMillis;
            return this;
        }

        @Override
        public final Builder closeNotifyReadTimeout(Duration closeNotifyReadTimeout) {
            Objects.requireNonNull(closeNotifyReadTimeout, "closeNotifyReadTimeout");
            return this.closeNotifyReadTimeoutMillis(closeNotifyReadTimeout.toMillis());
        }

        @Override
        public final Builder closeNotifyReadTimeoutMillis(long closeNotifyReadTimeoutMillis) {
            if (closeNotifyReadTimeoutMillis < 0L) {
                throw new IllegalArgumentException("ssl close_notify read timeout must be positive, was: " + closeNotifyReadTimeoutMillis);
            }
            this.closeNotifyReadTimeoutMillis = closeNotifyReadTimeoutMillis;
            return this;
        }

        @Override
        public SslProvider build() {
            return new SslProvider(this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Build build = (Build)o;
            return this.handshakeTimeoutMillis == build.handshakeTimeoutMillis && this.closeNotifyFlushTimeoutMillis == build.closeNotifyFlushTimeoutMillis && this.closeNotifyReadTimeoutMillis == build.closeNotifyReadTimeoutMillis && Objects.equals(this.sslCtxBuilder, build.sslCtxBuilder) && this.type == build.type && Objects.equals(this.sslContext, build.sslContext) && Objects.equals(this.handlerConfigurator, build.handlerConfigurator);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sslCtxBuilder, this.type, this.sslContext, this.handlerConfigurator, this.handshakeTimeoutMillis, this.closeNotifyFlushTimeoutMillis, this.closeNotifyReadTimeoutMillis});
        }
    }

    public static interface DefaultConfigurationSpec {
        public Builder defaultConfiguration(DefaultConfigurationType var1);
    }

    public static enum DefaultConfigurationType {
        NONE,
        TCP,
        H2;

    }

    public static interface SslContextSpec {
        public Builder sslContext(SslContext var1);

        public DefaultConfigurationSpec sslContext(SslContextBuilder var1);
    }

    public static interface Builder {
        public Builder handlerConfigurator(Consumer<? super SslHandler> var1);

        public Builder handshakeTimeout(Duration var1);

        public Builder handshakeTimeoutMillis(long var1);

        public Builder closeNotifyFlushTimeout(Duration var1);

        public Builder closeNotifyFlushTimeoutMillis(long var1);

        public Builder closeNotifyReadTimeout(Duration var1);

        public Builder closeNotifyReadTimeoutMillis(long var1);

        public SslProvider build();
    }
}

