/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLEngine;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private NetworkUtil() {
    }

    public static void configure(SocketChannel sc) throws IOException {
        sc.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
        sc.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                LOGGER.warn("Failed to close", (Throwable)e);
            }
        }
    }

    public static URI toUri(HttpHost host) throws URISyntaxException {
        return NetworkUtil.builderFrom(host).build();
    }

    public static URI toUri(HttpHost host, String path) throws URISyntaxException {
        return NetworkUtil.builderFrom(host).setPath(path).build();
    }

    public static URI appendUriPath(URI uri, String ... pathSegments) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(uri);
        ArrayList path = builder.getPathSegments();
        if (path.isEmpty()) {
            path = new ArrayList(pathSegments.length);
        }
        Collections.addAll(path, pathSegments);
        builder.setPathSegments(path);
        return builder.build();
    }

    public static URIBuilder builderFrom(HttpHost host) {
        return new URIBuilder().setHost(host.getHostName()).setPort(host.getPort()).setScheme(host.getSchemeName());
    }

    public static String toHostPort(String host, String port) {
        return InetAddressUtils.isIPv6Address((String)host) ? "[" + host + "]:" + port : host + ":" + port;
    }

    public static String toHostPort(String host, int port) {
        return InetAddressUtils.isIPv6Address((String)host) ? "[" + host + "]:" + port : host + ":" + port;
    }

    public static String toHostPort(InetSocketAddress address) {
        return address != null ? NetworkUtil.toHostPort(address.getHostString(), address.getPort()) : null;
    }

    public static String toHostPort(HttpHost httpHost) {
        if (httpHost == null) {
            return null;
        }
        int port = httpHost.getPort();
        if (port == -1) {
            port = "https".equalsIgnoreCase(httpHost.getSchemeName()) ? 443 : 80;
        }
        return NetworkUtil.toHostPort(httpHost.getHostName(), port);
    }

    public static String toHostPort(HttpHost httpHost, int defaultPort) {
        if (httpHost == null) {
            return null;
        }
        int port = httpHost.getPort();
        if (port == -1) {
            port = defaultPort;
        }
        return NetworkUtil.toHostPort(httpHost.getHostName(), port);
    }

    public static InetSocketAddress parseInetSocketAddress(String hostPortString) {
        int lastColon = hostPortString.lastIndexOf(58);
        String host = NetworkUtil.decodeIPv6LiteralHost(lastColon < 0 ? hostPortString : hostPortString.substring(0, lastColon));
        int port = lastColon < 0 ? 0 : Integer.parseInt(hostPortString.substring(lastColon + 1));
        return new InetSocketAddress(host, port);
    }

    public static InetSocketAddress toInetSocketAddress(String maybeLiteralHost, int port) {
        return new InetSocketAddress(NetworkUtil.decodeIPv6LiteralHost(maybeLiteralHost), port);
    }

    public static List<InetSocketAddress> parseInetSocketAddresses(String ... hostPortStrings) {
        ArrayList<InetSocketAddress> hosts = new ArrayList<InetSocketAddress>();
        for (String node : hostPortStrings) {
            hosts.add(NetworkUtil.parseInetSocketAddress(node));
        }
        return hosts;
    }

    public static String defaultPort(String maybeHostPort, int defaultPort) {
        Pair<String, Integer> decoded = NetworkUtil.extractHostPort(maybeHostPort, defaultPort);
        return NetworkUtil.encodeIPv6LiteralHost((String)decoded.getLeft()) + ":" + decoded.getRight();
    }

    public static Pair<String, Integer> extractHostPort(String maybeHostPort, int defaultPort) {
        try {
            int lastColon = maybeHostPort.lastIndexOf(58);
            if (lastColon == -1) {
                return Pair.of((Object)maybeHostPort, (Object)defaultPort);
            }
            int closeBracket = maybeHostPort.lastIndexOf(93);
            if (closeBracket == -1) {
                if (InetAddressUtils.isIPv6Address((String)maybeHostPort)) {
                    return Pair.of((Object)maybeHostPort, (Object)defaultPort);
                }
                return Pair.of((Object)maybeHostPort.substring(0, lastColon), (Object)Integer.parseInt(maybeHostPort.substring(lastColon + 1)));
            }
            if (closeBracket < lastColon) {
                return Pair.of((Object)NetworkUtil.decodeIPv6LiteralHost(maybeHostPort.substring(0, lastColon)), (Object)Integer.parseInt(maybeHostPort.substring(lastColon + 1)));
            }
            return Pair.of((Object)NetworkUtil.decodeIPv6LiteralHost(maybeHostPort), (Object)defaultPort);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encodeIPv6LiteralHost(String hostname) {
        return InetAddressUtils.isIPv6Address((String)hostname) ? "[" + hostname + "]" : hostname;
    }

    public static String decodeIPv6LiteralHost(String hostname) {
        return hostname.length() > 0 && hostname.charAt(0) == '[' ? hostname.substring(1, hostname.length() - 1) : hostname;
    }

    public static ByteBuffer enlargeSslPacketBuffer(SSLEngine engine, ByteBuffer buffer) {
        return NetworkUtil.enlargeSslBuffer(buffer, engine.getSession().getPacketBufferSize());
    }

    public static ByteBuffer enlargeSslApplicationBuffer(SSLEngine engine, ByteBuffer buffer) {
        return NetworkUtil.enlargeSslBuffer(buffer, engine.getSession().getApplicationBufferSize());
    }

    public static ByteBuffer enlargeSslBuffer(ByteBuffer src, int sessionProposedCapacity) {
        ByteBuffer enlargedBuffer = sessionProposedCapacity > src.capacity() ? ByteBuffer.allocate(sessionProposedCapacity) : ByteBuffer.allocate(src.capacity() * 2);
        src.flip();
        enlargedBuffer.put(src);
        return enlargedBuffer;
    }

    public static InetSocketAddress ensureUnresolved(InetSocketAddress address) {
        return address.isUnresolved() ? address : InetSocketAddress.createUnresolved(address.getHostString(), address.getPort());
    }

    public static InetSocketAddress ensureResolved(InetSocketAddress address) {
        return address.isUnresolved() ? new InetSocketAddress(address.getHostString(), address.getPort()) : address;
    }

    public static InetSocketAddress refresh(InetSocketAddress original) {
        InetSocketAddress refreshed = new InetSocketAddress(original.getHostString(), original.getPort());
        if (!Objects.equals(original.getAddress(), refreshed.getAddress())) {
            LOGGER.warn("ip address updated on refresh (was: {}, now: {})", (Object)original.getAddress(), (Object)refreshed.getAddress());
        }
        return refreshed;
    }

    public static InetSocketAddress toInetSocketAddress(HttpHost httpHost) {
        return new InetSocketAddress(httpHost.getAddress(), httpHost.getPort());
    }
}

