/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hyracks.util.cache.ICacheManager;
import org.apache.hyracks.util.cache.ICacheableValue;

public class CacheManager
implements ICacheManager {
    private final Map<String, ICacheableValue> registry = new ConcurrentHashMap<String, ICacheableValue>();

    @Override
    public void put(String key, ICacheableValue value) {
        this.registry.put(key, value);
        value.cache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        ICacheableValue value = this.registry.get(key);
        if (value == null) {
            return null;
        }
        ICacheableValue iCacheableValue = value;
        synchronized (iCacheableValue) {
            if (value.getPolicy().expired()) {
                value.cache();
            }
            return value.get();
        }
    }

    @Override
    public void invalidate(String key) {
        this.registry.remove(key);
    }
}

