/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hyracks.http.api.IServletResponse;
import org.apache.hyracks.http.server.ChunkedNettyOutputStream;
import org.apache.hyracks.http.server.HttpServerHandler;
import org.apache.hyracks.http.server.utils.HttpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkedResponse
implements IServletResponse {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ChannelHandlerContext ctx;
    private final ChunkedNettyOutputStream outputStream;
    private final HttpServerHandler<?> handler;
    private PrintWriter writer;
    private DefaultHttpResponse response;
    private boolean headerSent;
    private ByteBuf errorBuf;
    private ChannelFuture future;
    private boolean done;

    public ChunkedResponse(HttpServerHandler<?> handler, ChannelHandlerContext ctx, FullHttpRequest request, int chunkSize) {
        this.handler = handler;
        this.ctx = ctx;
        this.outputStream = new ChunkedNettyOutputStream(ctx, chunkSize, this);
        this.response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        this.response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        HttpUtil.setConnectionHeader((HttpRequest)request, this.response);
    }

    @Override
    public IServletResponse setHeader(CharSequence name, Object value) throws IOException {
        if (this.headerSent) {
            throw new IOException("Can't add more headers since the initial response was sent");
        }
        String nameString = String.valueOf(name);
        if (this.writer != null && nameString.equals(HttpHeaderNames.CONTENT_TYPE.toString())) {
            throw new IOException("Can't set " + HttpHeaderNames.CONTENT_TYPE + " after writer has been accessed");
        }
        this.response.headers().set(nameString, value);
        return this;
    }

    @Override
    public ChannelFuture lastContentFuture() {
        return this.future;
    }

    @Override
    public synchronized PrintWriter writer() {
        if (this.writer == null) {
            Charset charset = io.netty.handler.codec.http.HttpUtil.getCharset((HttpMessage)this.response, (Charset)StandardCharsets.UTF_8);
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.outputStream, charset));
        }
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.outputStream.close();
        }
        if (this.errorBuf == null && this.response.status() == HttpResponseStatus.OK) {
            if (!this.done) {
                this.respond((HttpObject)LastHttpContent.EMPTY_LAST_CONTENT);
            }
        } else if (this.headerSent) {
            LOGGER.log(Level.WARN, "Error after header write of chunked response");
            if (this.errorBuf != null) {
                this.errorBuf.release();
            }
            this.future = this.ctx.channel().close().addListener(this.handler);
        } else {
            this.fullResponse(this.response.protocolVersion(), this.response.status(), this.errorBuf == null ? this.ctx.alloc().buffer(0, 0) : this.errorBuf, this.response.headers());
        }
        this.done = true;
    }

    public HttpResponseStatus status() {
        return this.response.status();
    }

    public void beforeFlush() {
        if (!this.headerSent && this.response.status() == HttpResponseStatus.OK) {
            this.ctx.write((Object)this.response, this.ctx.channel().voidPromise());
            this.headerSent = true;
        }
    }

    public void error(ByteBuf error) {
        if (this.errorBuf == null) {
            this.errorBuf = this.ctx.alloc().buffer(error.readableBytes());
        }
        if (this.errorBuf.capacity() < this.errorBuf.capacity() + error.capacity()) {
            this.errorBuf.capacity(this.errorBuf.capacity() + error.capacity());
        }
        this.errorBuf.writeBytes(error);
    }

    @Override
    public OutputStream outputStream() {
        return this.outputStream;
    }

    @Override
    public void setStatus(HttpResponseStatus status) {
        this.response.setStatus(status);
    }

    public boolean isHeaderSent() {
        return this.headerSent;
    }

    public void fullResponse(ByteBuf buffer) {
        this.fullResponse(this.response.protocolVersion(), this.response.status(), buffer, this.response.headers());
    }

    private void fullResponse(HttpVersion version, HttpResponseStatus status, ByteBuf buffer, HttpHeaders headers) {
        DefaultFullHttpResponse fullResponse = new DefaultFullHttpResponse(version, status, buffer);
        fullResponse.headers().set(headers);
        fullResponse.headers().remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING);
        fullResponse.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, buffer.readableBytes());
        this.respond((HttpObject)fullResponse);
        this.headerSent = true;
        this.done = true;
    }

    @Override
    public void notifyChannelWritable() {
        this.outputStream.channelWritabilityChanged();
    }

    @Override
    public void notifyChannelInactive() {
        this.outputStream.channelWritabilityChanged();
    }

    @Override
    public void cancel() {
        this.outputStream.cancel();
    }

    private void respond(HttpObject response) {
        ChannelPromise responseCompletionPromise = this.ctx.newPromise();
        responseCompletionPromise.addListener(this.handler);
        this.future = this.ctx.writeAndFlush((Object)response, responseCompletionPromise);
    }
}

