/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.visitor.base;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.clause.GroupbyClause;
import org.apache.asterix.lang.common.clause.LetClause;
import org.apache.asterix.lang.common.clause.LimitClause;
import org.apache.asterix.lang.common.context.Scope;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.QuantifiedExpression;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.parser.ScopeChecker;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.statement.FunctionDecl;
import org.apache.asterix.lang.common.statement.InsertStatement;
import org.apache.asterix.lang.common.statement.Query;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.struct.QuantifiedPair;
import org.apache.asterix.lang.common.struct.VarIdentifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.AbstractBinaryCorrelateClause;
import org.apache.asterix.lang.sqlpp.clause.FromClause;
import org.apache.asterix.lang.sqlpp.clause.FromTerm;
import org.apache.asterix.lang.sqlpp.clause.JoinClause;
import org.apache.asterix.lang.sqlpp.clause.NestClause;
import org.apache.asterix.lang.sqlpp.clause.SelectSetOperation;
import org.apache.asterix.lang.sqlpp.clause.UnnestClause;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.expression.WindowExpression;
import org.apache.asterix.lang.sqlpp.struct.SetOperationRight;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppSimpleExpressionVisitor;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class AbstractSqlppExpressionScopingVisitor
extends AbstractSqlppSimpleExpressionVisitor {
    protected final ScopeChecker scopeChecker = new ScopeChecker();
    protected final LangRewritingContext context;

    public AbstractSqlppExpressionScopingVisitor(LangRewritingContext context) {
        this(context, null);
    }

    public AbstractSqlppExpressionScopingVisitor(LangRewritingContext context, Collection<VarIdentifier> externalVars) {
        this.context = context;
        this.scopeChecker.setVarCounter(context.getVarCounter());
        if (externalVars != null) {
            for (VarIdentifier paramVar : externalVars) {
                this.scopeChecker.getCurrentScope().addSymbolToScope((Identifier)paramVar);
            }
        }
    }

    @Override
    public Expression visit(FromClause fromClause, ILangExpression arg) throws CompilationException {
        Scope scopeForFromClause = this.scopeChecker.extendCurrentScope();
        for (FromTerm fromTerm : fromClause.getFromTerms()) {
            fromTerm.accept(this, fromClause);
            Scope scopeForFromTerm = this.scopeChecker.removeCurrentScope();
            this.mergeScopes(scopeForFromClause, scopeForFromTerm, fromTerm.getSourceLocation());
        }
        return null;
    }

    @Override
    public Expression visit(FromTerm fromTerm, ILangExpression arg) throws CompilationException {
        fromTerm.setLeftExpression(this.visit(fromTerm.getLeftExpression(), (ILangExpression)fromTerm));
        this.scopeChecker.createNewScope();
        VariableExpr leftVar = fromTerm.getLeftVariable();
        this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), leftVar.getVar(), leftVar.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        if (fromTerm.hasPositionalVariable()) {
            VariableExpr posVar = fromTerm.getPositionalVariable();
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), posVar.getVar(), posVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
        }
        for (AbstractBinaryCorrelateClause correlateClause : fromTerm.getCorrelateClauses()) {
            correlateClause.accept(this, (Object)fromTerm);
        }
        return null;
    }

    @Override
    public Expression visit(JoinClause joinClause, ILangExpression arg) throws CompilationException {
        Scope leftScope = this.scopeChecker.removeCurrentScope();
        this.scopeChecker.createNewScope();
        joinClause.setRightExpression(this.visit(joinClause.getRightExpression(), (ILangExpression)joinClause));
        VariableExpr rightVar = joinClause.getRightVariable();
        this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), rightVar.getVar(), rightVar.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        if (joinClause.hasPositionalVariable()) {
            VariableExpr posVar = joinClause.getPositionalVariable();
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), posVar.getVar(), posVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
        }
        Scope rightScope = this.scopeChecker.removeCurrentScope();
        this.mergeScopes(leftScope, rightScope, joinClause.getRightExpression().getSourceLocation());
        this.scopeChecker.pushExistingScope(leftScope);
        joinClause.setConditionExpression(this.visit(joinClause.getConditionExpression(), (ILangExpression)joinClause));
        return null;
    }

    @Override
    public Expression visit(NestClause nestClause, ILangExpression arg) throws CompilationException {
        nestClause.setRightExpression(this.visit(nestClause.getRightExpression(), (ILangExpression)nestClause));
        VariableExpr rightVar = nestClause.getRightVariable();
        this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), rightVar.getVar(), rightVar.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        if (nestClause.hasPositionalVariable()) {
            VariableExpr posVar = nestClause.getPositionalVariable();
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), posVar.getVar(), posVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
        }
        nestClause.setConditionExpression(this.visit(nestClause.getConditionExpression(), (ILangExpression)nestClause));
        return null;
    }

    @Override
    public Expression visit(UnnestClause unnestClause, ILangExpression arg) throws CompilationException {
        unnestClause.setRightExpression(this.visit(unnestClause.getRightExpression(), (ILangExpression)unnestClause));
        VariableExpr rightVar = unnestClause.getRightVariable();
        this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), rightVar.getVar(), rightVar.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        if (unnestClause.hasPositionalVariable()) {
            VariableExpr posVar = unnestClause.getPositionalVariable();
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), posVar.getVar(), posVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
        }
        return null;
    }

    @Override
    public Expression visit(SelectSetOperation selectSetOperation, ILangExpression arg) throws CompilationException {
        Scope scopeBeforeCurrentBranch = this.scopeChecker.getCurrentScope();
        this.scopeChecker.createNewScope();
        selectSetOperation.getLeftInput().accept(this, arg);
        if (selectSetOperation.hasRightInputs()) {
            for (SetOperationRight right : selectSetOperation.getRightInputs()) {
                while (this.scopeChecker.getCurrentScope() != scopeBeforeCurrentBranch) {
                    this.scopeChecker.removeCurrentScope();
                }
                this.scopeChecker.createNewScope();
                right.getSetOperationRightInput().accept(this, arg);
            }
            while (this.scopeChecker.getCurrentScope() != scopeBeforeCurrentBranch) {
                this.scopeChecker.removeCurrentScope();
            }
        }
        return null;
    }

    @Override
    public Expression visit(Query q, ILangExpression arg) throws CompilationException {
        q.setBody(this.visit(q.getBody(), (ILangExpression)q));
        q.setVarCounter(this.scopeChecker.getVarCounter());
        return null;
    }

    @Override
    public Expression visit(FunctionDecl fd, ILangExpression arg) throws CompilationException {
        this.scopeChecker.createNewScope();
        fd.setFuncBody(this.visit(fd.getFuncBody(), (ILangExpression)fd));
        this.scopeChecker.removeCurrentScope();
        return null;
    }

    @Override
    public Expression visit(GroupbyClause gc, ILangExpression arg) throws CompilationException {
        Scope newScope = new Scope(this.scopeChecker, this.scopeChecker.getPrecedingScope());
        HashSet<VariableExpr> gbyKeyVars = new HashSet<VariableExpr>();
        for (List gbyPairList : gc.getGbyPairList()) {
            for (GbyVariableExpressionPair gbyKeyVarExpr : gbyPairList) {
                gbyKeyVarExpr.setExpr(this.visit(gbyKeyVarExpr.getExpr(), (ILangExpression)gc));
                VariableExpr gbyKeyVar = gbyKeyVarExpr.getVar();
                if (gbyKeyVar == null || !gbyKeyVars.add(gbyKeyVar)) continue;
                this.addNewVarSymbolToScope(newScope, gbyKeyVar.getVar(), gbyKeyVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
            }
        }
        if (gc.hasGroupFieldList()) {
            for (Pair gbyField : gc.getGroupFieldList()) {
                gbyField.first = this.visit((Expression)gbyField.first, arg);
            }
        }
        if (gc.hasDecorList()) {
            for (GbyVariableExpressionPair decorVarExpr : gc.getDecorPairList()) {
                decorVarExpr.setExpr(this.visit(decorVarExpr.getExpr(), (ILangExpression)gc));
                VariableExpr decorVar = decorVarExpr.getVar();
                if (decorVar == null) continue;
                this.addNewVarSymbolToScope(newScope, decorVar.getVar(), decorVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
            }
        }
        if (gc.hasGroupVar()) {
            VariableExpr groupVar = gc.getGroupVar();
            this.addNewVarSymbolToScope(newScope, groupVar.getVar(), groupVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
        }
        if (gc.hasWithMap()) {
            HashMap<Expression, VariableExpr> newWithMap = new HashMap<Expression, VariableExpr>();
            for (Map.Entry entry : gc.getWithVarMap().entrySet()) {
                Expression expr;
                Expression newKey = expr = this.visit((Expression)entry.getKey(), arg);
                VariableExpr value = (VariableExpr)entry.getValue();
                this.addNewVarSymbolToScope(newScope, value.getVar(), value.getSourceLocation(), new SqlppVariableAnnotation[0]);
                newWithMap.put(newKey, value);
            }
            gc.setWithVarMap(newWithMap);
        }
        this.scopeChecker.replaceCurrentScope(newScope);
        return null;
    }

    @Override
    public Expression visit(LimitClause limitClause, ILangExpression arg) throws CompilationException {
        this.scopeChecker.pushForbiddenScope(this.scopeChecker.getCurrentScope());
        if (limitClause.hasLimitExpr()) {
            limitClause.setLimitExpr(this.visit(limitClause.getLimitExpr(), (ILangExpression)limitClause));
        }
        if (limitClause.hasOffset()) {
            limitClause.setOffset(this.visit(limitClause.getOffset(), (ILangExpression)limitClause));
        }
        this.scopeChecker.popForbiddenScope();
        return null;
    }

    @Override
    public Expression visit(LetClause letClause, ILangExpression arg) throws CompilationException {
        this.scopeChecker.extendCurrentScope();
        letClause.setBindingExpr(this.visit(letClause.getBindingExpr(), (ILangExpression)letClause));
        VariableExpr varExpr = letClause.getVarExpr();
        this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), varExpr.getVar(), varExpr.getSourceLocation(), new SqlppVariableAnnotation[0]);
        return null;
    }

    @Override
    public Expression visit(SelectExpression selectExpression, ILangExpression arg) throws CompilationException {
        Scope scopeBeforeSelectExpression = this.scopeChecker.getCurrentScope();
        this.scopeChecker.createNewScope();
        if (selectExpression.hasLetClauses()) {
            for (LetClause letClause : selectExpression.getLetList()) {
                letClause.accept((ILangVisitor)this, (Object)selectExpression);
            }
            this.scopeChecker.createNewScope();
        }
        selectExpression.getSelectSetOperation().accept(this, selectExpression);
        if (selectExpression.hasOrderby()) {
            selectExpression.getOrderbyClause().accept((ILangVisitor)this, (Object)selectExpression);
        }
        if (selectExpression.hasLimit()) {
            selectExpression.getLimitClause().accept((ILangVisitor)this, (Object)selectExpression);
        }
        while (this.scopeChecker.getCurrentScope() != scopeBeforeSelectExpression) {
            this.scopeChecker.removeCurrentScope();
        }
        return selectExpression;
    }

    @Override
    public Expression visit(QuantifiedExpression qe, ILangExpression arg) throws CompilationException {
        this.scopeChecker.createNewScope();
        for (QuantifiedPair pair : qe.getQuantifiedList()) {
            pair.setExpr(this.visit(pair.getExpr(), (ILangExpression)qe));
            VariableExpr varExpr = pair.getVarExpr();
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), varExpr.getVar(), varExpr.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        }
        qe.setSatisfiesExpr(this.visit(qe.getSatisfiesExpr(), (ILangExpression)qe));
        this.scopeChecker.removeCurrentScope();
        return qe;
    }

    @Override
    public Expression visit(VariableExpr varExpr, ILangExpression arg) throws CompilationException {
        String varName = varExpr.getVar().getValue();
        if (this.scopeChecker.isInForbiddenScopes(varName)) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, varExpr.getSourceLocation(), new Serializable[]{"Inside limit clauses, it is disallowed to reference a variable having the same name as any variable bound in the same scope as the limit clause."});
        }
        Identifier ident = this.scopeChecker.lookupSymbol(varName);
        if (ident != null) {
            varExpr.setIsNewVar(false);
            varExpr.setVar((VarIdentifier)ident);
        }
        return varExpr;
    }

    @Override
    public Expression visit(InsertStatement insertStatement, ILangExpression arg) throws CompilationException {
        Expression returningExpr;
        this.scopeChecker.createNewScope();
        insertStatement.getQuery().accept((ILangVisitor)this, (Object)insertStatement);
        VariableExpr bindingVar = insertStatement.getVar();
        if (bindingVar != null) {
            this.addNewVarSymbolToScope(this.scopeChecker.getCurrentScope(), bindingVar.getVar(), bindingVar.getSourceLocation(), SqlppVariableAnnotation.CONTEXT_VARIABLE);
        }
        if ((returningExpr = insertStatement.getReturnExpression()) != null) {
            insertStatement.setReturnExpression(this.visit(returningExpr, (ILangExpression)insertStatement));
        }
        return null;
    }

    @Override
    public Expression visit(WindowExpression winExpr, ILangExpression arg) throws CompilationException {
        this.visitWindowExpressionExcludingExprListAndAggFilter(winExpr, arg);
        if (winExpr.hasWindowVar()) {
            Scope preScope = this.scopeChecker.getCurrentScope();
            Scope newScope = this.scopeChecker.extendCurrentScope();
            VariableExpr windowVar = winExpr.getWindowVar();
            this.addNewVarSymbolToScope(newScope, windowVar.getVar(), windowVar.getSourceLocation(), new SqlppVariableAnnotation[0]);
            winExpr.setExprList(this.visit(winExpr.getExprList(), arg));
            if (winExpr.hasAggregateFilterExpr()) {
                winExpr.setAggregateFilterExpr(this.visit(winExpr.getAggregateFilterExpr(), arg));
            }
            this.scopeChecker.replaceCurrentScope(preScope);
        } else {
            winExpr.setExprList(this.visit(winExpr.getExprList(), arg));
            if (winExpr.hasAggregateFilterExpr()) {
                winExpr.setAggregateFilterExpr(this.visit(winExpr.getAggregateFilterExpr(), arg));
            }
        }
        return winExpr;
    }

    private void addNewVarSymbolToScope(Scope scope, VarIdentifier var, SourceLocation sourceLoc, SqlppVariableAnnotation ... varAnnotations) throws CompilationException {
        Set annotations;
        if (scope.findLocalSymbol(var.getValue()) != null) {
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Duplicate alias definitions: " + SqlppVariableUtil.toUserDefinedName(var.getValue())});
        }
        if (varAnnotations == null || varAnnotations.length == 0) {
            annotations = Collections.emptySet();
        } else {
            annotations = EnumSet.noneOf(SqlppVariableAnnotation.class);
            Collections.addAll(annotations, varAnnotations);
        }
        scope.addNewVarSymbolToScope(var, annotations);
    }

    private void mergeScopes(Scope hostScope, Scope scopeToBeMerged, SourceLocation sourceLoc) throws CompilationException {
        Set symbolsToBeMerged = scopeToBeMerged.getLocalSymbols();
        for (String symbolToBeMerged : symbolsToBeMerged) {
            if (hostScope.findLocalSymbol(symbolToBeMerged) == null) continue;
            throw new CompilationException(ErrorCode.COMPILATION_ERROR, sourceLoc, new Serializable[]{"Duplicate alias definitions: " + SqlppVariableUtil.toUserDefinedName(symbolToBeMerged)});
        }
        hostScope.merge(scopeToBeMerged);
    }

    public static enum SqlppVariableAnnotation implements Scope.SymbolAnnotation
    {
        CONTEXT_VARIABLE;

    }
}

