/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.management;

import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Enumeration;
import org.apache.hyracks.api.comm.NetworkAddress;
import org.apache.hyracks.api.network.ISocketChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkingUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    private NetworkingUtil() {
        throw new AssertionError((Object)"This util class should not be initialized.");
    }

    public static void readBytes(ISocketChannel socketChannel, ByteBuffer byteBuffer, int length) throws IOException {
        byteBuffer.clear();
        byteBuffer.limit(length);
        while (byteBuffer.remaining() > 0 && socketChannel.read(byteBuffer) > 0) {
        }
        if (byteBuffer.remaining() > 0) {
            throw new EOFException();
        }
        byteBuffer.flip();
    }

    public static void sendFile(FileChannel fileChannel, ISocketChannel socketChannel) throws IOException {
        long remainingBytes;
        long pos = 0L;
        try {
            long sentBytes;
            for (remainingBytes = fileChannel.size(); remainingBytes > 0L; remainingBytes -= sentBytes) {
                sentBytes = fileChannel.transferTo(pos, remainingBytes, (WritableByteChannel)socketChannel);
                pos += sentBytes;
            }
            socketChannel.getSocketChannel().socket().getOutputStream().flush();
        }
        catch (Exception e) {
            LOGGER.info("failed to send file; file size {}, pos {}, remainingBytes {}", (Object)fileChannel.size(), (Object)pos, (Object)remainingBytes);
        }
    }

    public static void downloadFile(FileChannel fileChannel, ISocketChannel socketChannel) throws IOException {
        long remainingBytes;
        long pos = 0L;
        try {
            long readBytes;
            for (remainingBytes = fileChannel.size(); remainingBytes > 0L; remainingBytes -= readBytes) {
                readBytes = fileChannel.transferFrom((ReadableByteChannel)socketChannel, pos, remainingBytes);
                pos += readBytes;
            }
        }
        catch (Exception e) {
            LOGGER.info("failed to download file; file size {}, pos {}, remainingBytes {}", (Object)fileChannel.size(), (Object)pos, (Object)remainingBytes);
            throw e;
        }
    }

    public static String getHostAddress(String hostIPAddressFirstOctet) throws SocketException {
        String hostName = null;
        Enumeration<NetworkInterface> nInterfaces = NetworkInterface.getNetworkInterfaces();
        block0: while (nInterfaces.hasMoreElements() && hostName == null) {
            Enumeration<InetAddress> inetAddresses = nInterfaces.nextElement().getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                String address = inetAddresses.nextElement().getHostAddress();
                if (!address.startsWith(hostIPAddressFirstOctet)) continue;
                hostName = address;
                continue block0;
            }
        }
        return hostName;
    }

    public static void transferBufferToChannel(ISocketChannel socketChannel, ByteBuffer requestBuffer) throws IOException {
        while (requestBuffer.hasRemaining()) {
            socketChannel.write(requestBuffer);
        }
    }

    public static void sendFileNIO(FileChannel fileChannel, SocketChannel socketChannel) throws IOException {
        long fileSize = fileChannel.size();
        MappedByteBuffer bb = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileSize);
        socketChannel.write(bb);
    }

    public static void downloadFileNIO(FileChannel fileChannel, SocketChannel socketChannel) throws IOException {
        long pos = 0L;
        long fileSize = fileChannel.size();
        fileChannel.transferFrom(socketChannel, pos, fileSize);
    }

    public static InetSocketAddress getSocketAddress(SocketChannel socketChannel) {
        String hostAddress = socketChannel.socket().getInetAddress().getHostAddress();
        int port = socketChannel.socket().getPort();
        return InetSocketAddress.createUnresolved(hostAddress, port);
    }

    public static SocketAddress getSocketAddress(NetworkAddress netAddr) throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getByAddress(netAddr.lookupIpAddress()), netAddr.getPort());
    }

    public static boolean isHealthy(ISocketChannel sc) {
        return sc != null && sc.getSocketChannel().isOpen() && sc.getSocketChannel().isConnected();
    }
}

