/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.StreamLimitPOperator;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class CopyLimitDownRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.LIMIT) {
            return false;
        }
        LimitOperator limitOp = (LimitOperator)op;
        if (!limitOp.isTopmostLimitOp() || !limitOp.hasMaxObjects()) {
            return false;
        }
        ArrayList<LogicalVariable> limitUsedVars = new ArrayList<LogicalVariable>();
        VariableUtilities.getUsedVariables((ILogicalOperator)limitOp, limitUsedVars);
        ArrayList safeOps = new ArrayList();
        ArrayList<LogicalVariable> tmpCandidateProducedVars = new ArrayList<LogicalVariable>();
        ILogicalOperator limitInputOp = (ILogicalOperator)((Mutable)limitOp.getInputs().get(0)).getValue();
        this.findSafeOpsInSubtree(limitInputOp, limitUsedVars, safeOps, tmpCandidateProducedVars);
        if (safeOps.isEmpty()) {
            return false;
        }
        SourceLocation sourceLoc = limitOp.getSourceLocation();
        for (ILogicalOperator safeOp : safeOps) {
            for (Mutable unsafeOpRef : safeOp.getInputs()) {
                ILogicalExpression newMaxObjectsExpr;
                ILogicalOperator unsafeOp = (ILogicalOperator)unsafeOpRef.getValue();
                ILogicalExpression maxObjectsExpr = (ILogicalExpression)limitOp.getMaxObjects().getValue();
                if (!limitOp.hasOffset()) {
                    newMaxObjectsExpr = maxObjectsExpr.cloneExpression();
                } else {
                    IFunctionInfo finfoAdd = context.getMetadataProvider().lookupFunction(AlgebricksBuiltinFunctions.NUMERIC_ADD);
                    ArrayList<MutableObject> addArgs = new ArrayList<MutableObject>(2);
                    addArgs.add(new MutableObject((Object)maxObjectsExpr.cloneExpression()));
                    addArgs.add(new MutableObject((Object)((ILogicalExpression)limitOp.getOffset().getValue()).cloneExpression()));
                    ScalarFunctionCallExpression maxPlusOffset = new ScalarFunctionCallExpression(finfoAdd, addArgs);
                    maxPlusOffset.setSourceLocation(sourceLoc);
                    newMaxObjectsExpr = maxPlusOffset;
                }
                LimitOperator limitCloneOp = new LimitOperator(newMaxObjectsExpr, false);
                limitCloneOp.setSourceLocation(sourceLoc);
                limitCloneOp.setPhysicalOperator((IPhysicalOperator)new StreamLimitPOperator());
                limitCloneOp.getInputs().add(new MutableObject((Object)unsafeOp));
                limitCloneOp.setExecutionMode(unsafeOp.getExecutionMode());
                context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)limitCloneOp);
                limitCloneOp.recomputeSchema();
                unsafeOpRef.setValue((Object)limitCloneOp);
            }
        }
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)limitOp);
        return true;
    }

    private boolean findSafeOpsInSubtree(ILogicalOperator candidateOp, List<LogicalVariable> limitUsedVars, Collection<? super ILogicalOperator> outSafeOps, List<LogicalVariable> tmpCandidateProducedVars) throws AlgebricksException {
        ILogicalOperator safeOp = null;
        while (CopyLimitDownRule.isSafeOpCandidate(candidateOp)) {
            tmpCandidateProducedVars.clear();
            VariableUtilities.getProducedVariables((ILogicalOperator)candidateOp, tmpCandidateProducedVars);
            if (!OperatorPropertiesUtil.disjoint(limitUsedVars, tmpCandidateProducedVars)) break;
            List candidateOpInputs = candidateOp.getInputs();
            if (candidateOpInputs.size() > 1) {
                boolean foundSafeOpInBranch = false;
                for (Mutable inputOpRef : candidateOpInputs) {
                    foundSafeOpInBranch |= this.findSafeOpsInSubtree((ILogicalOperator)inputOpRef.getValue(), limitUsedVars, outSafeOps, tmpCandidateProducedVars);
                }
                if (!foundSafeOpInBranch) {
                    outSafeOps.add((ILogicalOperator)candidateOp);
                }
                return true;
            }
            safeOp = candidateOp;
            candidateOp = (ILogicalOperator)((Mutable)candidateOpInputs.get(0)).getValue();
        }
        if (safeOp != null) {
            outSafeOps.add(safeOp);
            return true;
        }
        return false;
    }

    private static boolean isSafeOpCandidate(ILogicalOperator op) {
        switch (op.getOperatorTag()) {
            case UNIONALL: 
            case SUBPLAN: {
                return true;
            }
            case SELECT: 
            case UNNEST: 
            case UNNEST_MAP: {
                return false;
            }
        }
        return op.getInputs().size() == 1 && op.isMap();
    }
}

