/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class SplitOperator
extends AbstractReplicateOperator {
    private final Mutable<ILogicalExpression> branchingExpression;
    private final int defaultBranch;
    private final boolean propageToAllBranchAsDefault;

    public SplitOperator(int outputArity, Mutable<ILogicalExpression> branchingExpression) {
        this(outputArity, branchingExpression, 0, false);
    }

    public SplitOperator(int outputArity, Mutable<ILogicalExpression> branchingExpression, int defaultBranch, boolean propageToAllBranchForMissingExprValue) {
        super(outputArity);
        this.branchingExpression = branchingExpression;
        this.defaultBranch = defaultBranch;
        this.propageToAllBranchAsDefault = propageToAllBranchForMissingExprValue;
    }

    @Override
    public LogicalOperatorTag getOperatorTag() {
        return LogicalOperatorTag.SPLIT;
    }

    @Override
    public <R, T> R accept(ILogicalOperatorVisitor<R, T> visitor, T arg) throws AlgebricksException {
        return visitor.visitSplitOperator(this, arg);
    }

    public Mutable<ILogicalExpression> getBranchingExpression() {
        return this.branchingExpression;
    }

    public int getDefaultBranch() {
        return this.defaultBranch;
    }

    public boolean getPropageToAllBranchAsDefault() {
        return this.propageToAllBranchAsDefault;
    }

    @Override
    public boolean acceptExpressionTransform(ILogicalExpressionReferenceTransform visitor) throws AlgebricksException {
        return visitor.transform(this.branchingExpression);
    }
}

