/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IActiveNotificationHandler;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.util.SingleThreadEventProcessor;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveNotificationHandler
extends SingleThreadEventProcessor<ActiveEvent>
implements IActiveNotificationHandler,
IJobLifecycleListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.DEBUG;
    public static final String ACTIVE_ENTITY_PROPERTY_NAME = "ActiveJob";
    private final Map<EntityId, IActiveEntityEventsListener> entityEventListeners;
    private final Map<JobId, EntityId> jobId2EntityId = new HashMap<JobId, EntityId>();
    private boolean suspended = false;

    public ActiveNotificationHandler() {
        super(ActiveNotificationHandler.class.getSimpleName());
        this.entityEventListeners = new HashMap<EntityId, IActiveEntityEventsListener>();
    }

    protected void handle(ActiveEvent event) {
        JobId jobId = event.getJobId();
        ActiveEvent.Kind eventKind = event.getEventKind();
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
            if (eventKind == ActiveEvent.Kind.JOB_FINISHED) {
                LOGGER.debug("removing ingestion job {}", (Object)jobId);
                this.jobId2EntityId.remove(jobId);
            }
            if (listener != null) {
                listener.notify(event);
            } else {
                LOGGER.debug("listener not found for entity {} on event={}", (Object)entityId, (Object)event);
            }
        } else {
            LOGGER.error("entity not found for event {}", (Object)event);
        }
    }

    public void notifyJobCreation(JobId jobId, JobSpecification jobSpecification) throws HyracksDataException {
        Serializable property = jobSpecification.getProperty(ACTIVE_ENTITY_PROPERTY_NAME);
        if (!(property instanceof EntityId)) {
            if (property != null) {
                LOGGER.debug("{} is not an active job. job property={}", (Object)jobId, (Object)property);
            }
            return;
        }
        LOGGER.debug("notified of ingestion job creation {}", (Object)jobId);
        EntityId entityId = (EntityId)property;
        this.monitorJob(jobId, entityId);
        this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_CREATED, entityId, (Object)jobSpecification));
    }

    private synchronized void monitorJob(JobId jobId, EntityId entityId) {
        boolean found = this.jobId2EntityId.containsKey(jobId);
        LOGGER.debug("{} is {}", (Object)jobId, (Object)(found ? "active" : "inactive"));
        if (this.entityEventListeners.containsKey(entityId)) {
            if (found) {
                LOGGER.error("{} is already being monitored", (Object)jobId);
                return;
            }
            LOGGER.debug("monitoring started for {}", (Object)jobId);
        } else {
            LOGGER.debug("no listener found for entity {}; {}", (Object)entityId, (Object)jobId);
        }
        this.jobId2EntityId.put(jobId, entityId);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_STARTED, entityId, null));
        }
    }

    public synchronized void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            LOGGER.debug("notified of ingestion job finish {}", (Object)jobId);
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_FINISHED, entityId, (Object)Pair.of((Object)jobStatus, exceptions)));
        }
    }

    public void receive(ActivePartitionMessage message) {
        this.add(new ActiveEvent(message.getJobId(), ActiveEvent.Kind.PARTITION_EVENT, message.getActiveRuntimeId().getEntityId(), (Object)message));
    }

    public IActiveEntityEventsListener getListener(EntityId entityId) {
        return this.entityEventListeners.get(entityId);
    }

    public synchronized IActiveEntityEventsListener[] getEventListeners() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getEventListeners() returning {} listeners", (Object)this.entityEventListeners.size());
        }
        return (IActiveEntityEventsListener[])this.entityEventListeners.values().toArray(IActiveEntityEventsListener[]::new);
    }

    public synchronized Collection<IActiveEntityEventsListener> getEventListenersAsList() {
        return Collections.unmodifiableCollection(this.entityEventListeners.values());
    }

    public synchronized void registerListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.suspended) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_NOTIFICATION_HANDLER_IS_SUSPENDED, new Serializable[0]);
        }
        LOGGER.debug("register listener for entity {}, state={}", (Object)listener.getEntityId(), (Object)listener.getState());
        if (this.entityEventListeners.containsKey(listener.getEntityId())) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_ENTITY_IS_ALREADY_REGISTERED, new Serializable[]{listener.getEntityId()});
        }
        this.entityEventListeners.put(listener.getEntityId(), listener);
    }

    public synchronized void unregisterListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.suspended) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_NOTIFICATION_HANDLER_IS_SUSPENDED, new Serializable[0]);
        }
        LOGGER.debug("unregister listener for entity {}, state={}", (Object)listener.getEntityId(), (Object)listener.getState());
        IActiveEntityEventsListener registeredListener = this.entityEventListeners.remove(listener.getEntityId());
        if (registeredListener == null) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_ENTITY_LISTENER_IS_NOT_REGISTERED, new Serializable[]{listener.getEntityId()});
        }
        if (registeredListener.isActive() && !registeredListener.isSuspended()) {
            this.entityEventListeners.put(registeredListener.getEntityId(), registeredListener);
            throw new RuntimeDataException(ErrorCode.CANNOT_DERIGESTER_ACTIVE_ENTITY_LISTENER, new Serializable[]{listener.getEntityId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        LOGGER.info("Starting active recovery");
        IActiveEntityEventsListener[] iActiveEntityEventsListenerArray = this.getEventListeners();
        int n = iActiveEntityEventsListenerArray.length;
        for (int i = 0; i < n; ++i) {
            IActiveEntityEventsListener listener;
            IActiveEntityEventsListener iActiveEntityEventsListener = listener = iActiveEntityEventsListenerArray[i];
            synchronized (iActiveEntityEventsListener) {
                LOGGER.debug("entity {} is {}, active={}, suspended={}", (Object)listener.getEntityId(), (Object)listener.getState(), (Object)listener.isActive(), (Object)listener.isSuspended());
                listener.notifyAll();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(MetadataProvider mdProvider, String reason) throws HyracksDataException {
        ActiveNotificationHandler activeNotificationHandler = this;
        synchronized (activeNotificationHandler) {
            if (this.suspended) {
                throw new RuntimeDataException(ErrorCode.ACTIVE_EVENT_HANDLER_ALREADY_SUSPENDED, new Serializable[0]);
            }
            LOGGER.debug("suspending active events handler. reason {}", (Object)reason);
            this.suspended = true;
        }
        Collection<IActiveEntityEventsListener> registeredListeners = this.entityEventListeners.values();
        for (IActiveEntityEventsListener listener : registeredListeners) {
            this.suspendForDdlOrHalt(listener, mdProvider, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(MetadataProvider mdProvider) {
        LOGGER.log(level, "Resuming active events handler");
        for (IActiveEntityEventsListener listener : this.entityEventListeners.values()) {
            this.resumeOrHalt(listener, mdProvider);
        }
        Object object = this;
        synchronized (object) {
            this.suspended = false;
        }
    }

    public void suspendForDdlOrHalt(IActiveEntityEventsListener listener, MetadataProvider metadataProvider, Dataset targetDataset) {
        try {
            EntityId entityId = listener.getEntityId();
            LOGGER.log(level, "Suspending {}", (Object)entityId);
            LOGGER.log(level, "Acquiring locks for {}", (Object)entityId);
            ((ActiveEntityEventsListener)listener).acquireSuspendLocks(metadataProvider, targetDataset);
            LOGGER.log(level, "locks acquired for {}", (Object)entityId);
            ((ActiveEntityEventsListener)listener).suspend(metadataProvider);
            LOGGER.log(level, "{} suspended", (Object)entityId);
        }
        catch (Throwable th) {
            LOGGER.error("Suspend active failed", th);
            ExitUtil.halt((int)17);
        }
    }

    public void resumeOrHalt(IActiveEntityEventsListener listener, MetadataProvider metadataProvider) {
        try {
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "Resuming {}", (Object)listener.getEntityId());
            }
            ((ActiveEntityEventsListener)listener).resume(metadataProvider);
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "{} resumed", (Object)listener.getEntityId());
            }
        }
        catch (Throwable th) {
            LOGGER.error("Resume active failed", th);
            ExitUtil.halt((int)18);
        }
    }
}

