/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.nc.task;

import java.util.Set;
import org.apache.asterix.common.api.INCLifecycleTask;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.storage.IReplicaManager;
import org.apache.hyracks.api.client.NodeStatus;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.service.IControllerService;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpdateNodeStatusTask
implements INCLifecycleTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 2L;
    private final NodeStatus status;
    private final Set<Integer> activePartitions;

    public UpdateNodeStatusTask(NodeStatus status, Set<Integer> activePartitions) {
        this.status = status;
        this.activePartitions = activePartitions;
    }

    public void perform(CcId ccId, IControllerService cs) throws HyracksDataException {
        NodeControllerService ncs = (NodeControllerService)cs;
        ncs.setNodeStatus(this.status);
        if (this.status != NodeStatus.ACTIVE) {
            this.updateNodeActivePartitions(cs);
        }
    }

    private void updateNodeActivePartitions(IControllerService cs) {
        INcApplicationContext appCtx = (INcApplicationContext)cs.getApplicationContext();
        IReplicaManager replicaManager = appCtx.getReplicaManager();
        LOGGER.info("updating node active partitions to {}", this.activePartitions);
        replicaManager.setActivePartitions(this.activePartitions);
    }

    public String toString() {
        return "UpdateNodeStatusTask{status=" + this.status + ", activePartitions=" + this.activePartitions + "}";
    }
}

