/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.resource;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SwitchOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.WindowPOperator;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.api.job.resource.IClusterCapacity;

public class RequiredCapacityVisitor
implements ILogicalOperatorVisitor<Void, Void> {
    private static final long MAX_BUFFER_PER_CONNECTION = 1L;
    private final long numComputationPartitions;
    private final long groupByMemorySize;
    private final long joinMemorySize;
    private final long sortMemorySize;
    private final long frameSize;
    private final IClusterCapacity clusterCapacity;
    private final Set<ILogicalOperator> visitedOperators = new HashSet<ILogicalOperator>();
    private long stageMemorySoFar = 0L;

    public RequiredCapacityVisitor(int numComputationPartitions, int sortFrameLimit, int groupFrameLimit, int joinFrameLimit, int frameSize, IClusterCapacity clusterCapacity) {
        this.numComputationPartitions = numComputationPartitions;
        this.frameSize = frameSize;
        this.groupByMemorySize = (long)groupFrameLimit * (long)frameSize;
        this.joinMemorySize = (long)joinFrameLimit * (long)frameSize;
        this.sortMemorySize = (long)sortFrameLimit * (long)frameSize;
        this.clusterCapacity = clusterCapacity;
        this.clusterCapacity.setAggregatedCores(1);
    }

    public Void visitAggregateOperator(AggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitGroupByOperator(GroupByOperator op, Void arg) throws AlgebricksException {
        this.calculateMemoryUsageForBlockingOperators((ILogicalOperator)op, this.groupByMemorySize);
        return null;
    }

    public Void visitLimitOperator(LimitOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitInnerJoinOperator(InnerJoinOperator op, Void arg) throws AlgebricksException {
        this.calculateMemoryUsageForBlockingOperators((ILogicalOperator)op, this.joinMemorySize);
        return null;
    }

    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Void arg) throws AlgebricksException {
        this.calculateMemoryUsageForBlockingOperators((ILogicalOperator)op, this.joinMemorySize);
        return null;
    }

    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitOrderOperator(OrderOperator op, Void arg) throws AlgebricksException {
        this.calculateMemoryUsageForBlockingOperators((ILogicalOperator)op, this.sortMemorySize);
        return null;
    }

    public Void visitAssignOperator(AssignOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitSelectOperator(SelectOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitDelegateOperator(DelegateOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitProjectOperator(ProjectOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitReplicateOperator(ReplicateOperator op, Void arg) throws AlgebricksException {
        if (!this.visitedOperators.contains(op)) {
            this.visitedOperators.add((ILogicalOperator)op);
            this.visitInternal((ILogicalOperator)op, true);
        }
        return null;
    }

    public Void visitSplitOperator(SplitOperator op, Void arg) throws AlgebricksException {
        if (!this.visitedOperators.contains(op)) {
            this.visitedOperators.add((ILogicalOperator)op);
            this.visitInternal((ILogicalOperator)op, true);
        }
        return null;
    }

    public Void visitSwitchOperator(SwitchOperator op, Void arg) throws AlgebricksException {
        throw new NotImplementedException();
    }

    public Void visitMaterializeOperator(MaterializeOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitScriptOperator(ScriptOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitSubplanOperator(SubplanOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitSinkOperator(SinkOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitUnionOperator(UnionAllOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitIntersectOperator(IntersectOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitUnnestOperator(UnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitUnnestMapOperator(UnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitDataScanOperator(DataSourceScanOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitDistinctOperator(DistinctOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitExchangeOperator(ExchangeOperator op, Void arg) throws AlgebricksException {
        this.calculateMemoryUsageForExchange(op);
        return null;
    }

    public Void visitWriteOperator(WriteOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitDistributeResultOperator(DistributeResultOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitWriteResultOperator(WriteResultOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitTokenizeOperator(TokenizeOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitForwardOperator(ForwardOperator op, Void arg) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, true);
        return null;
    }

    public Void visitWindowOperator(WindowOperator op, Void arg) throws AlgebricksException {
        WindowPOperator physOp = (WindowPOperator)op.getPhysicalOperator();
        this.visitInternal((ILogicalOperator)op, true);
        this.addOutputBuffer((ILogicalOperator)op);
        if (physOp.getOperatorTag() == PhysicalOperatorTag.WINDOW) {
            this.addOutputBuffer((ILogicalOperator)op);
        }
        return null;
    }

    private void calculateMemoryUsageForExchange(ExchangeOperator op) throws AlgebricksException {
        this.visitInternal((ILogicalOperator)op, false);
        IPhysicalOperator physicalOperator = op.getPhysicalOperator();
        PhysicalOperatorTag physicalOperatorTag = physicalOperator.getOperatorTag();
        if (physicalOperatorTag == PhysicalOperatorTag.ONE_TO_ONE_EXCHANGE || physicalOperatorTag == PhysicalOperatorTag.SORT_MERGE_EXCHANGE) {
            this.addOutputBuffer((ILogicalOperator)op);
            return;
        }
        this.stageMemorySoFar += 2L * this.numComputationPartitions * this.numComputationPartitions * this.frameSize;
        this.clusterCapacity.setAggregatedMemoryByteSize(this.stageMemorySoFar);
    }

    private void calculateMemoryUsageForBlockingOperators(ILogicalOperator op, long memSize) throws AlgebricksException {
        this.visitInternal(op, false);
        this.stageMemorySoFar = op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL ? (this.stageMemorySoFar += memSize * this.numComputationPartitions) : (this.stageMemorySoFar += memSize);
        this.clusterCapacity.setAggregatedMemoryByteSize(this.stageMemorySoFar);
    }

    private void visitInternal(ILogicalOperator op, boolean toAddOuputBuffer) throws AlgebricksException {
        for (Mutable inputOpRef : op.getInputs()) {
            ((ILogicalOperator)inputOpRef.getValue()).accept((ILogicalOperatorVisitor)this, null);
        }
        if (toAddOuputBuffer) {
            this.addOutputBuffer(op);
        }
        this.setAvailableCores(op);
    }

    private void addOutputBuffer(ILogicalOperator op) {
        this.stageMemorySoFar = op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL ? (this.stageMemorySoFar += this.frameSize * this.numComputationPartitions) : (this.stageMemorySoFar += this.frameSize);
        this.clusterCapacity.setAggregatedMemoryByteSize(this.stageMemorySoFar);
    }

    private void setAvailableCores(ILogicalOperator op) {
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED || op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.LOCAL) {
            this.clusterCapacity.setAggregatedCores((int)this.numComputationPartitions);
        }
    }
}

