/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.messaging;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.common.config.MessagingProperties;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.memory.FrameAction;
import org.apache.asterix.common.messaging.api.INcAddressedMessage;
import org.apache.asterix.messaging.MessagingChannelReadInterface;
import org.apache.asterix.messaging.MessagingChannelWriteInterface;
import org.apache.asterix.messaging.NCMessageBroker;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.comm.IBufferFactory;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.IChannelInterfaceFactory;
import org.apache.hyracks.api.comm.IChannelReadInterface;
import org.apache.hyracks.api.comm.IChannelWriteInterface;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagingChannelInterfaceFactory
implements IChannelInterfaceFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NCMessageBroker messageBroker;
    private final ConcurrentFramePool messagingFramePool;
    private final IBufferFactory appMessagingBufferFactor = new AppMessagingBufferFactory();
    private final int msgFrameSize;
    private final int channelFrameCount;

    public MessagingChannelInterfaceFactory(NCMessageBroker messageBroker, MessagingProperties messagingProperties) {
        this.messageBroker = messageBroker;
        this.messagingFramePool = messageBroker.getMessagingFramePool();
        this.msgFrameSize = messagingProperties.getFrameSize();
        this.channelFrameCount = messagingProperties.getFrameCount();
    }

    public IChannelReadInterface createReadInterface(IChannelControlBlock ccb) {
        AppMessagingEmptyBufferAcceptor readEmptyBufferAcceptor = new AppMessagingEmptyBufferAcceptor();
        MessagingChannelReadInterface readInterface = new MessagingChannelReadInterface(readEmptyBufferAcceptor);
        readInterface.setBufferFactory(this.appMessagingBufferFactor, this.channelFrameCount, this.msgFrameSize);
        readInterface.setFullBufferAcceptor(new AppMessagingReadFullBufferAcceptor(readEmptyBufferAcceptor));
        return readInterface;
    }

    public IChannelWriteInterface createWriteInterface(IChannelControlBlock ccb) {
        MessagingChannelWriteInterface writeInterface = new MessagingChannelWriteInterface(ccb);
        writeInterface.setBufferFactory(this.appMessagingBufferFactor, this.channelFrameCount, this.msgFrameSize);
        writeInterface.setEmptyBufferAcceptor(new AppMessagingEmptyBufferAcceptor());
        return writeInterface;
    }

    private final class AppMessagingBufferFactory
    implements IBufferFactory {
        private final FrameAction frameAction = new FrameAction();

        private AppMessagingBufferFactory() {
        }

        public ByteBuffer createBuffer() throws HyracksDataException {
            ByteBuffer buffer = MessagingChannelInterfaceFactory.this.messagingFramePool.get();
            if (buffer == null) {
                try {
                    MessagingChannelInterfaceFactory.this.messagingFramePool.subscribe(this.frameAction);
                    buffer = this.frameAction.retrieve();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return buffer;
        }

        public int getCreatedBuffersCount() {
            return 0;
        }
    }

    private class AppMessagingEmptyBufferAcceptor
    implements IBufferAcceptor {
        private AppMessagingEmptyBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
            block2: {
                try {
                    MessagingChannelInterfaceFactory.this.messagingFramePool.release(buffer);
                }
                catch (HyracksDataException e) {
                    if (!LOGGER.isWarnEnabled()) break block2;
                    LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private class AppMessagingReadFullBufferAcceptor
    implements ICloseableBufferAcceptor {
        private final IBufferAcceptor recycle;

        private AppMessagingReadFullBufferAcceptor(IBufferAcceptor recycle) {
            this.recycle = recycle;
        }

        public void accept(ByteBuffer buffer) {
            try {
                INcAddressedMessage receivedMsg = (INcAddressedMessage)JavaSerializationUtils.deserialize((byte[])buffer.array());
                MessagingChannelInterfaceFactory.this.messageBroker.queueReceivedMessage(receivedMsg);
            }
            catch (IOException | ClassNotFoundException e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.log(Level.WARN, e.getMessage(), (Throwable)e);
                }
            }
            finally {
                this.recycle.accept(buffer);
            }
        }

        public void close() {
        }

        public void error(int ecode) {
        }
    }
}

