/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeTagUtil;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractArrayMoveSwapEval
implements IScalarEvaluator {
    private final ArrayBackedValueStorage storage;
    private final IScalarEvaluator listArgEval;
    private final IScalarEvaluator oldIndexEval;
    private final IScalarEvaluator newIndexEval;
    private final IPointable listArg;
    private final IPointable oldIndex;
    private final IPointable newIndex;
    private final ListAccessor listAccessor;
    private IAsterixListBuilder listBuilder;
    private String funcIdentifier;
    private IAType inputListType;

    AbstractArrayMoveSwapEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, String funcIdentifier, IAType inputListType) throws HyracksDataException {
        this.funcIdentifier = funcIdentifier;
        this.inputListType = inputListType;
        this.storage = new ArrayBackedValueStorage();
        this.listArgEval = args[0].createScalarEvaluator(ctx);
        this.oldIndexEval = args[1].createScalarEvaluator(ctx);
        this.newIndexEval = args[2].createScalarEvaluator(ctx);
        this.listArg = new VoidPointable();
        this.oldIndex = new VoidPointable();
        this.newIndex = new VoidPointable();
        this.listAccessor = new ListAccessor();
        this.listBuilder = new OrderedListBuilder();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.storage.reset();
        this.listArgEval.evaluate(tuple, this.listArg);
        this.oldIndexEval.evaluate(tuple, this.oldIndex);
        this.newIndexEval.evaluate(tuple, this.newIndex);
        if (PointableHelper.checkAndSetMissingOrNull(result, this.listArg, this.oldIndex, this.newIndex)) {
            return;
        }
        byte[] listBytes = this.listArg.getByteArray();
        int offset = this.listArg.getStartOffset();
        ATypeTag listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[offset]);
        byte[] oldIndexBytes = this.oldIndex.getByteArray();
        int oldIndexOffset = this.oldIndex.getStartOffset();
        ATypeTag oldIndexType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(oldIndexBytes[oldIndexOffset]);
        byte[] newIndexBytes = this.newIndex.getByteArray();
        int newIndexOffset = this.newIndex.getStartOffset();
        ATypeTag newIndexType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(newIndexBytes[newIndexOffset]);
        if (listType != ATypeTag.ARRAY || !ATypeHierarchy.isCompatible((ATypeTag)oldIndexType, (ATypeTag)ATypeTag.DOUBLE) || !ATypeHierarchy.isCompatible((ATypeTag)newIndexType, (ATypeTag)ATypeTag.DOUBLE)) {
            PointableHelper.setNull(result);
            return;
        }
        this.listAccessor.reset(listBytes, offset);
        ATypeTag listItemTypeTag = this.listAccessor.getItemType();
        IAType listItemType = TypeTagUtil.getBuiltinTypeByTag((ATypeTag)listItemTypeTag);
        Object outputListType = this.listAccessor.getListType() == ATypeTag.ARRAY ? new AOrderedListType(listItemType, listItemType.getTypeName()) : (AbstractCollectionType)this.inputListType;
        this.listBuilder.reset(outputListType);
        try {
            int listLen = this.listAccessor.size();
            double oldIndexVal = ATypeHierarchy.getDoubleValue((String)this.funcIdentifier, (int)1, (byte[])oldIndexBytes, (int)oldIndexOffset);
            double newIndexVal = ATypeHierarchy.getDoubleValue((String)this.funcIdentifier, (int)2, (byte[])newIndexBytes, (int)newIndexOffset);
            if (Double.isNaN(oldIndexVal) || Double.isInfinite(oldIndexVal) || Math.floor(oldIndexVal) < oldIndexVal || newIndexVal > (double)(listLen - 1) || newIndexVal < (double)(-listLen) || oldIndexVal < (double)(-listLen) || oldIndexVal > (double)(listLen - 1)) {
                PointableHelper.setNull(result);
                return;
            }
            int oldIndexInt = (int)oldIndexVal;
            int newIndexInt = (int)newIndexVal;
            if ((oldIndexInt = (oldIndexInt + listLen) % listLen) == (newIndexInt = (newIndexInt + listLen) % listLen) || listLen <= 1) {
                result.set((IValueReference)this.listArg);
                return;
            }
            this.buildList(oldIndexInt, newIndexInt, listLen, this.listAccessor, this.listBuilder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.storage.reset();
        this.listBuilder.write(this.storage.getDataOutput(), true);
        result.set((IValueReference)this.storage);
    }

    protected void buildList(int oldIndexInt, int newIndexInt, int listLen, ListAccessor listAccessor, IAsterixListBuilder listBuilder) throws IOException {
        for (int i = 0; i < listLen; ++i) {
            this.storage.reset();
            listAccessor.writeItem(oldIndexInt, this.storage.getDataOutput());
            listBuilder.addItem((IValueReference)this.storage);
        }
    }
}

