/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.operators.joins.spatial.utils.memory;

import org.apache.asterix.runtime.operators.joins.interval.utils.memory.ITupleCursor;
import org.apache.asterix.runtime.operators.joins.spatial.utils.ISpatialJoinUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class SpatialSideTuple {
    int[] fieldId;
    ITupleCursor cursor;
    final ISpatialJoinUtil imjc;

    public SpatialSideTuple(ISpatialJoinUtil imjc, ITupleCursor cursor, int[] fieldId) {
        this.imjc = imjc;
        this.cursor = cursor;
        this.fieldId = fieldId;
    }

    public int getTupleIndex() {
        return this.cursor.getTupleId();
    }

    public ITupleCursor getCursor() {
        return this.cursor;
    }

    public boolean compareJoin(SpatialSideTuple ist) throws HyracksDataException {
        return this.imjc.checkToSaveInResult(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }

    public boolean removeFromMemory(SpatialSideTuple ist) throws HyracksDataException {
        return this.imjc.checkToRemoveInMemory(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }

    public boolean checkForEarlyExit(SpatialSideTuple ist) throws HyracksDataException {
        return this.imjc.checkForEarlyExit(this.cursor.getAccessor(), this.cursor.getTupleId(), ist.cursor.getAccessor(), ist.cursor.getTupleId());
    }
}

